function [s, ind] = my_removeExcessBits(bits)
%REMOVEEXCESSBITS Extracts the complete subframes in the bit sequence
%obtained from a satellite
%   [S, IDX] = REMOVEEXCESSBITS(BITS) detects the start of the first
%   subframe in the row vector BITS (values in {-1,+1}) by correlating
%   with the GPS preamble (stored in gpsc.preamble as a sequence of
%   1s and 0s). If the negative of the preamble is found all bits
%   are inverted. IDX is the index into BITS where the first subframe
%   starts; incomplete subframes at the beginning and at the end of
%   BITS are removed and the sequence of bits is converted into a
%   sequence of {0,1} values ({1,-1} <-> {0,1}) and returned into
%   vector S.
%
% Hints:
% - The preamble is stored in gpsc.preamble as a sequence of 0s and 1s.
% - It is not enough to just find one preamble: the preamble is 8 bits
%   long and it is not unlikely that this 8-bit sequence is also
%   present somewhere in the middle of the data sequence. You should
%   use the fact that there is one preamble in every subframe (every
%   300 bits).
% - The result of xcorr() are real numbers and it can have multiple maxima.
%   If you want to compare two values returned by xcorr(), you should first
%   round them using MATLAB's function round().
