function [subframes, subframesIDs] = my_bits2subframes(bits)
%BITS2SUBFRAMES Returns a matrix containing the subframes
%   in the desired order
%   [SUBFRAMES, SUBFRAMESIDS] = BITS2SUBFRAMES(BITS) returns the matrix
%   SUBFRAMES having as its columns the subframes extracted from BITS.
%   The IDs of the subframes are returned in SUBFRAMESIDS.  BITS must
%   be a row vector containing a concatenation of subframes (0 and 1
%   elements) that have already been checked for parity.  Provided that
%   BITS is sufficiently long, SUBFRAMES contains the subframes with
%   id 1,2,3, in that order. (It might contain additional subframes 
%   and the first column is not necessarily subframe 1.)
%   These are the subframes that we use to obtain the ephemerides.
