/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.quantumtunneling.view.QTXYPlot;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.ui.Layer;

public class QTMarkerNode
extends PPath
implements PlotChangeListener {
    private QTXYPlot _plot;
    private Rectangle2D _dataArea;
    private String _name;
    private RenderingHints _renderingHints;

    public QTMarkerNode(QTXYPlot qTXYPlot) {
        this._plot = qTXYPlot;
        this._plot.addChangeListener(this);
        this._dataArea = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this._name = null;
        this._renderingHints = null;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this._renderingHints = renderingHints;
    }

    public void setDataArea(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D);
        this._dataArea.setRect(rectangle2D);
        this.repaint();
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.repaint();
    }

    protected void paint(PPaintContext pPaintContext) {
        int n;
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this._renderingHints != null) {
            graphics2D.setRenderingHints(this._renderingHints);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(this._dataArea);
        int n2 = this._plot.getDatasetCount();
        for (n = 0; n < n2; ++n) {
            this._plot.drawDomainMarkers(graphics2D, this._dataArea, n, Layer.BACKGROUND);
            this._plot.drawDomainMarkers(graphics2D, this._dataArea, n, Layer.FOREGROUND);
        }
        for (n = 0; n < n2; ++n) {
            this._plot.drawRangeMarkers(graphics2D, this._dataArea, n, Layer.BACKGROUND);
            this._plot.drawRangeMarkers(graphics2D, this._dataArea, n, Layer.FOREGROUND);
        }
        graphics2D.setClip(shape);
    }
}

