/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.model.AbstractWave;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractProbabilityNode
extends PText
implements Observer {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Font FONT = new PhetFont(0, 18);
    private AbstractWave _wave;
    private char _label;
    private double _value;

    private AbstractProbabilityNode(char c) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.setFont(FONT);
        this.setTextPaint(DEFAULT_COLOR);
        this._label = c;
        this.setValue(-1.0);
    }

    public void update(Observable observable, Object object) {
        this.update();
    }

    public abstract void update();

    public void setWave(AbstractWave abstractWave) {
        if (this._wave != null) {
            this._wave.deleteObserver(this);
        }
        this._wave = abstractWave;
        this._wave.addObserver(this);
        this.update();
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this.setTextPaint(qTColorScheme.getAnnotationColor());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.isInitialized()) {
            this.update();
        }
    }

    protected AbstractWave getWave() {
        return this._wave;
    }

    protected void setValue(double d) {
        if (d != this._value) {
            this._value = d;
            String string = null;
            string = this._value < 0.0 ? this._label + "=?" : this._label + "=" + FORMAT.format(this._value);
            this.setText(string);
        }
    }

    private boolean isInitialized() {
        return this._wave != null;
    }

    public static class ReflectionProbabilityNode
    extends AbstractProbabilityNode {
        public ReflectionProbabilityNode() {
            super(QTResources.getChar("char.reflectionProbability", 'R'));
        }

        public void update() {
            if (this.getVisible()) {
                double d = this.getWave().getReflectionProbability();
                this.setValue(d);
            }
        }
    }

    public static class TransmissionProbabilityNode
    extends AbstractProbabilityNode {
        public TransmissionProbabilityNode() {
            super(QTResources.getChar("char.transmissionProbability", 'T'));
        }

        public void update() {
            if (this.getVisible()) {
                double d = this.getWave().getTransmissionProbability();
                this.setValue(d);
            }
        }
    }
}

