/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.math.MutableComplex;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPlaneSolver;
import edu.colorado.phet.quantumtunneling.model.StepPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;

public class StepSolver
extends AbstractPlaneSolver {
    private MutableComplex _B;
    private MutableComplex _C;

    public StepSolver(TotalEnergy totalEnergy, StepPotential stepPotential, Direction direction) {
        super(totalEnergy, stepPotential, direction);
    }

    public WaveFunctionSolution solve(double d, double d2) {
        WaveFunctionSolution waveFunctionSolution = null;
        if (this.isSolutionZero()) {
            waveFunctionSolution = new WaveFunctionSolution(d, d2, Complex.ZERO, Complex.ZERO);
        } else {
            int n = this.getPotentialEnergy().getRegionIndexAt(d);
            if (this.isRightToLeft()) {
                n = this.flipRegionIndex(n);
            }
            if (n == 0) {
                waveFunctionSolution = this.solveRegion1(d, d2);
            } else if (n == 1) {
                waveFunctionSolution = this.solveRegion2(d, d2);
            }
        }
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion1(double d, double d2) {
        Complex complex = this.getK(0);
        Complex complex2 = StepSolver.commonTerm1(complex, d);
        Complex complex3 = StepSolver.commonTerm2(complex, d);
        Complex complex4 = StepSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = complex2.getMultiply(complex4);
        Complex complex6 = this._B.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion2(double d, double d2) {
        Complex complex = this.getK(1);
        Complex complex2 = StepSolver.commonTerm1(complex, d);
        Complex complex3 = StepSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex4 = this._C.getMultiply(complex2).getMultiply(complex3);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex4);
        return waveFunctionSolution;
    }

    protected void updateCoefficients() {
        double d = this.getBoundary(0, 1);
        Complex complex = this.getK(0);
        Complex complex2 = this.getK(1);
        Complex complex3 = StepSolver.getDenominator(complex, complex2);
        this.updateB(d, complex, complex2, complex3);
        this.updateC(d, complex, complex2, complex3);
    }

    private void updateB(double d, Complex complex, Complex complex2, Complex complex3) {
        if (this._B == null) {
            this._B = new MutableComplex();
        }
        this._B.setValue(2.0);
        this._B.multiply(Complex.I);
        this._B.multiply(complex);
        this._B.multiply(d);
        this._B.exp();
        this._B.multiply(complex.getSubtract(complex2));
        this._B.divide(complex3);
    }

    private void updateC(double d, Complex complex, Complex complex2, Complex complex3) {
        if (this._C == null) {
            this._C = new MutableComplex();
        }
        this._C.setValue(Complex.I);
        this._C.multiply(complex.getSubtract(complex2));
        this._C.multiply(d);
        this._C.exp();
        this._C.multiply(2.0);
        this._C.multiply(complex);
        this._C.divide(complex3);
    }

    private static Complex getDenominator(Complex complex, Complex complex2) {
        return complex.getAdd(complex2);
    }

    public Complex getB() {
        if (this._B == null) {
            this.solve(0.0, 0.0);
        }
        return this._B;
    }
}

