/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPlaneSolver;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.ConstantPotential;
import edu.colorado.phet.quantumtunneling.model.ConstantSolver;
import edu.colorado.phet.quantumtunneling.model.DoubleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.DoubleBarrierSolver;
import edu.colorado.phet.quantumtunneling.model.SingleBarrierPotential;
import edu.colorado.phet.quantumtunneling.model.SingleBarrierSolver;
import edu.colorado.phet.quantumtunneling.model.StepPotential;
import edu.colorado.phet.quantumtunneling.model.StepSolver;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;

public class SolverFactory {
    public static AbstractPlaneSolver createSolver(TotalEnergy totalEnergy, AbstractPotential abstractPotential, Direction direction) {
        AbstractPlaneSolver abstractPlaneSolver = null;
        if (abstractPotential instanceof ConstantPotential) {
            abstractPlaneSolver = new ConstantSolver(totalEnergy, (ConstantPotential)abstractPotential, direction);
        } else if (abstractPotential instanceof StepPotential) {
            abstractPlaneSolver = new StepSolver(totalEnergy, (StepPotential)abstractPotential, direction);
        } else if (abstractPotential instanceof SingleBarrierPotential) {
            abstractPlaneSolver = new SingleBarrierSolver(totalEnergy, (SingleBarrierPotential)abstractPotential, direction);
        } else if (abstractPotential instanceof DoubleBarrierPotential) {
            abstractPlaneSolver = new DoubleBarrierSolver(totalEnergy, (DoubleBarrierPotential)abstractPotential, direction);
        } else {
            throw new IllegalArgumentException("unsupported potential type: " + abstractPotential.getClass().getName());
        }
        return abstractPlaneSolver;
    }
}

