/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.common.phetcommon.math.MutableComplex;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractBarrierSolver;
import edu.colorado.phet.quantumtunneling.model.BarrierPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;

public class SingleBarrierSolver
extends AbstractBarrierSolver {
    private MutableComplex _B;
    private MutableComplex _C;
    private MutableComplex _D;
    private MutableComplex _F;

    public SingleBarrierSolver(TotalEnergy totalEnergy, BarrierPotential barrierPotential, Direction direction) {
        super(totalEnergy, barrierPotential, direction);
        assert (barrierPotential.getNumberOfBarriers() == 1);
    }

    public WaveFunctionSolution solve(double d, double d2) {
        WaveFunctionSolution waveFunctionSolution = null;
        if (this.isSolutionZero()) {
            waveFunctionSolution = new WaveFunctionSolution(d, d2, Complex.ZERO, Complex.ZERO);
        } else {
            int n = this.getPotentialEnergy().getRegionIndexAt(d);
            if (this.isRightToLeft()) {
                n = this.flipRegionIndex(n);
            }
            switch (n) {
                case 0: {
                    waveFunctionSolution = this.solveRegion1(d, d2);
                    break;
                }
                case 1: {
                    waveFunctionSolution = this.solveRegion2(d, d2);
                    break;
                }
                case 2: {
                    waveFunctionSolution = this.solveRegion3(d, d2);
                    break;
                }
                default: {
                    waveFunctionSolution = null;
                }
            }
        }
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion1(double d, double d2) {
        Complex complex = this.getK(0);
        Complex complex2 = SingleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = SingleBarrierSolver.commonTerm2(complex, d);
        Complex complex4 = SingleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = complex2.getMultiply(complex4);
        Complex complex6 = this._B.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion2(double d, double d2) {
        Complex complex = this.getK(1);
        Complex complex2 = SingleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = SingleBarrierSolver.commonTerm2(complex, d);
        Complex complex4 = SingleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex5 = this._C.getMultiply(complex2).getMultiply(complex4);
        Complex complex6 = this._D.getMultiply(complex3).getMultiply(complex4);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex5, complex6);
        return waveFunctionSolution;
    }

    private WaveFunctionSolution solveRegion3(double d, double d2) {
        Complex complex = this.getK(2);
        Complex complex2 = SingleBarrierSolver.commonTerm1(complex, d);
        Complex complex3 = SingleBarrierSolver.commonTerm3(this.getTotalEnergy(), d2);
        Complex complex4 = this._F.getMultiply(complex2).getMultiply(complex3);
        WaveFunctionSolution waveFunctionSolution = new WaveFunctionSolution(d, d2, complex4);
        return waveFunctionSolution;
    }

    protected void updateCoefficients() {
        double d = this.getBoundary(0, 1);
        double d2 = this.getBoundary(1, 2);
        Complex complex = this.getK(0);
        Complex complex2 = this.getK(1);
        Complex complex3 = this.getK(2);
        Complex complex4 = SingleBarrierSolver.getDenominator(d, d2, complex, complex2, complex3);
        this.updateB(d, d2, complex, complex2, complex3, complex4);
        this.updateC(d, d2, complex, complex2, complex3, complex4);
        this.updateD(d, d2, complex, complex2, complex3, complex4);
        this.updateF(d, d2, complex, complex2, complex3, complex4);
    }

    private void updateB(double d, double d2, Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        MutableComplex mutableComplex = new MutableComplex();
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.multiply(complex);
        mutableComplex2.multiply(d);
        mutableComplex2.exp();
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(2.0);
        mutableComplex3.multiply(Complex.I);
        mutableComplex3.multiply(complex2);
        mutableComplex3.multiply(d2);
        mutableComplex3.exp();
        mutableComplex3.multiply(complex.getAdd(complex2));
        mutableComplex3.multiply(complex2.getSubtract(complex3));
        MutableComplex mutableComplex4 = new MutableComplex();
        mutableComplex4.setValue(2.0);
        mutableComplex4.multiply(Complex.I);
        mutableComplex4.multiply(complex2);
        mutableComplex4.multiply(d);
        mutableComplex4.exp();
        mutableComplex4.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex4.multiply(complex2.getAdd(complex3));
        mutableComplex.setValue(mutableComplex3);
        mutableComplex.subtract(mutableComplex4);
        mutableComplex.multiply(mutableComplex2);
        if (this._B == null) {
            this._B = new MutableComplex();
        }
        this._B.setValue(mutableComplex);
        this._B.divide(complex4);
    }

    private void updateC(double d, double d2, Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(Complex.I);
        mutableComplex.multiply(complex.getAdd(complex2));
        mutableComplex.multiply(d);
        mutableComplex.exp();
        mutableComplex.multiply(2.0);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(complex2.getAdd(complex3));
        if (this._C == null) {
            this._C = new MutableComplex();
        }
        this._C.setValue(mutableComplex);
        this._C.divide(complex4);
    }

    private void updateD(double d, double d2, Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(complex.getAdd(complex2));
        mutableComplex.multiply(d);
        mutableComplex.add(complex2.getMultiply(2.0 * d2));
        mutableComplex.multiply(Complex.I);
        mutableComplex.exp();
        mutableComplex.multiply(2.0);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(complex2.getSubtract(complex3));
        if (this._D == null) {
            this._D = new MutableComplex();
        }
        this._D.setValue(mutableComplex);
        this._D.divide(complex4);
    }

    private void updateF(double d, double d2, Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(complex.getMultiply(d));
        mutableComplex.subtract(complex3.getMultiply(d2));
        mutableComplex.add(complex2.getMultiply(d + d2));
        mutableComplex.multiply(Complex.I);
        mutableComplex.exp();
        mutableComplex.multiply(4.0);
        mutableComplex.multiply(complex);
        mutableComplex.multiply(complex2);
        if (this._F == null) {
            this._F = new MutableComplex();
        }
        this._F.setValue(mutableComplex);
        this._F.divide(complex4);
    }

    private static Complex getDenominator(double d, double d2, Complex complex, Complex complex2, Complex complex3) {
        MutableComplex mutableComplex = new MutableComplex();
        mutableComplex.setValue(2.0);
        mutableComplex.multiply(Complex.I);
        mutableComplex.multiply(complex2);
        mutableComplex.multiply(d2);
        mutableComplex.exp();
        mutableComplex.multiply(complex.getMultiply(-1.0).getAdd(complex2));
        mutableComplex.multiply(complex2.getSubtract(complex3));
        mutableComplex.multiply(-1.0);
        MutableComplex mutableComplex2 = new MutableComplex();
        mutableComplex2.setValue(2.0);
        mutableComplex2.multiply(Complex.I);
        mutableComplex2.multiply(complex2);
        mutableComplex2.multiply(d);
        mutableComplex2.exp();
        mutableComplex2.multiply(complex.getAdd(complex2));
        mutableComplex2.multiply(complex2.getAdd(complex3));
        MutableComplex mutableComplex3 = new MutableComplex();
        mutableComplex3.setValue(mutableComplex);
        mutableComplex3.add(mutableComplex2);
        return mutableComplex3;
    }

    public Complex getB() {
        if (this._B == null) {
            this.solve(0.0, 0.0);
        }
        return this._B;
    }
}

