/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.common.phetcommon.math.Complex;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.model.AbstractPlaneSolver;
import edu.colorado.phet.quantumtunneling.model.ConstantPotential;
import edu.colorado.phet.quantumtunneling.model.TotalEnergy;
import edu.colorado.phet.quantumtunneling.model.WaveFunctionSolution;

public class ConstantSolver
extends AbstractPlaneSolver {
    public ConstantSolver(TotalEnergy totalEnergy, ConstantPotential constantPotential, Direction direction) {
        super(totalEnergy, constantPotential, direction);
    }

    public WaveFunctionSolution solve(double d, double d2) {
        WaveFunctionSolution waveFunctionSolution = null;
        if (this.isSolutionZero()) {
            waveFunctionSolution = new WaveFunctionSolution(d, d2, Complex.ZERO, Complex.ZERO);
        } else {
            Complex complex = this.getK(0);
            Complex complex2 = ConstantSolver.commonTerm1(complex, d);
            Complex complex3 = ConstantSolver.commonTerm3(this.getTotalEnergy(), d2);
            Complex complex4 = complex2.getMultiply(complex3);
            waveFunctionSolution = new WaveFunctionSolution(d, d2, complex4);
        }
        return waveFunctionSolution;
    }

    protected void updateCoefficients() {
    }

    protected Complex getB() {
        return Complex.ZERO;
    }
}

