/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.quantumtunneling.model.AbstractPotential;

public class BarrierPotential
extends AbstractPotential {
    public BarrierPotential(int n) {
        super(n * 2 + 1);
        if (n <= 0) {
            throw new IllegalArgumentException("numberOfBarriers must be > 0: " + n);
        }
        for (int i = 0; i < this.getNumberOfRegions(); ++i) {
            double d;
            double d2;
            double d3;
            if (i == 0) {
                this.setRegion(i, this.getMinPosition(), 0.0, 0.0);
                continue;
            }
            if (i == this.getNumberOfRegions() - 1) {
                this.setRegion(i, this.getEnd(i - 1), this.getMaxPosition(), 0.0);
                continue;
            }
            if (BarrierPotential.isaBarrier(i)) {
                d3 = this.getEnd(i - 1);
                d2 = d3 + 1.0;
                d = 0.5;
                this.setRegion(i, d3, d2, d);
                continue;
            }
            d3 = this.getEnd(i - 1);
            d2 = d3 + 1.0;
            d = 0.0;
            this.setRegion(i, d3, d2, d);
        }
        this.validateRegions();
    }

    public BarrierPotential(BarrierPotential barrierPotential) {
        super(barrierPotential);
    }

    public int getNumberOfBarriers() {
        return (this.getNumberOfRegions() - 1) / 2;
    }

    public boolean setBarrierPosition(int n, double d) {
        if (n > this.getNumberOfBarriers() - 1) {
            throw new IllegalArgumentException("barrierIndex out of range: " + n);
        }
        boolean bl = false;
        int n2 = BarrierPotential.toRegionIndex(n);
        double d2 = this.getMinRegionWidth();
        if (d - d2 >= this.getStart(n2 - 1) && d + this.getWidth(n2) + d2 <= this.getEnd(n2 + 1)) {
            this.setNotifyEnabled(false);
            double d3 = d;
            double d4 = d + this.getWidth(n2);
            this.setRegion(n2, d3, d4);
            this.setEnd(n2 - 1, d3);
            this.setStart(n2 + 1, d4);
            this.setNotifyEnabled(true);
            this.validateRegions();
            bl = true;
        }
        return bl;
    }

    public double getBarrierPosition(int n) {
        if (n > this.getNumberOfBarriers() - 1) {
            throw new IllegalArgumentException("barrierIndex out of range: " + n);
        }
        int n2 = BarrierPotential.toRegionIndex(n);
        return this.getStart(n2);
    }

    public boolean setBarrierWidth(int n, double d) {
        if (n > this.getNumberOfBarriers() - 1) {
            throw new IllegalArgumentException("barrierIndex out of range: " + n);
        }
        boolean bl = false;
        int n2 = BarrierPotential.toRegionIndex(n);
        double d2 = this.getMinRegionWidth();
        if (d >= d2 && this.getStart(n2) + d + d2 <= this.getEnd(n2 + 1)) {
            this.setNotifyEnabled(false);
            double d3 = this.getStart(n2) + d;
            this.setEnd(n2, d3);
            this.setStart(n2 + 1, d3);
            this.setNotifyEnabled(true);
            this.validateRegions();
            bl = true;
        }
        return bl;
    }

    public static int toRegionIndex(int n) {
        return n * 2 + 1;
    }

    public static int toBarrierIndex(int n) {
        int n2 = -1;
        if (BarrierPotential.isaBarrier(n)) {
            n2 = (n - 1) / 2;
        }
        return n2;
    }

    public static boolean isaBarrier(int n) {
        return n % 2 != 0;
    }
}

