/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.model;

import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.model.PotentialRegion;
import edu.colorado.phet.quantumtunneling.model.QTObservable;
import org.jfree.data.Range;

public abstract class AbstractPotential
extends QTObservable {
    private PotentialRegion[] _regions;
    private double _minRegionWidth;

    protected AbstractPotential(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("numberOfRegions must be > 0");
        }
        this._regions = new PotentialRegion[n];
        if (n == 1) {
            this._regions[0] = new PotentialRegion(this.getMinPosition(), this.getMaxPosition(), 0.0);
        } else {
            for (int i = 0; i < n; ++i) {
                this._regions[i] = i == 0 ? new PotentialRegion(this.getMinPosition(), i + 1, 0.0) : (i == n - 1 ? new PotentialRegion(i, this.getMaxPosition(), 0.0) : new PotentialRegion(i, i + 1, 0.0));
            }
        }
        this._minRegionWidth = 0.1;
    }

    protected AbstractPotential(AbstractPotential abstractPotential) {
        this._regions = new PotentialRegion[abstractPotential.getNumberOfRegions()];
        for (int i = 0; i < abstractPotential.getNumberOfRegions(); ++i) {
            double d = abstractPotential.getRegion(i).getStart();
            double d2 = abstractPotential.getRegion(i).getEnd();
            double d3 = abstractPotential.getRegion(i).getEnergy();
            this.setRegion(i, d, d2, d3);
        }
        this._minRegionWidth = abstractPotential.getMinRegionWidth();
    }

    public void setRegions(PotentialRegion[] potentialRegionArray) {
        this._regions = potentialRegionArray;
        this.validateRegions();
    }

    public PotentialRegion[] getRegions() {
        return this._regions;
    }

    public int getNumberOfRegions() {
        return this._regions.length;
    }

    public double getStart(int n) {
        return this.getRegion(n).getStart();
    }

    public double getEnd(int n) {
        return this.getRegion(n).getEnd();
    }

    public double getMiddle(int n) {
        return this.getRegion(n).getMiddle();
    }

    public double getWidth(int n) {
        return this.getRegion(n).getWidth();
    }

    public double getEnergy(int n) {
        return this.getRegion(n).getEnergy();
    }

    public void setEnergy(int n, double d) {
        this.validateRegionIndex(n);
        double d2 = this.getRegion(n).getStart();
        double d3 = this.getRegion(n).getEnd();
        this.setRegion(n, d2, d3, d);
    }

    public double getMinPosition() {
        return this.getPositionRangeReference().getLowerBound();
    }

    public double getMaxPosition() {
        return this.getPositionRangeReference().getUpperBound();
    }

    public double getMinRegionWidth() {
        return this._minRegionWidth;
    }

    public void setMinRegionWidth(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("minRegionWidth must be > 0");
        }
        this._minRegionWidth = d;
        this.notifyObservers();
    }

    public int getRegionIndexAt(double d) {
        int n = this._regions.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            if (!(d < this.getRegion(i).getEnd())) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public double getEnergyAt(double d) {
        int n = this.getRegionIndexAt(d);
        PotentialRegion potentialRegion = this.getRegion(n);
        return potentialRegion.getEnergy();
    }

    public boolean adjustBoundary(int n, double d) {
        this.validateRegionIndex(n);
        if (this.getNumberOfRegions() == 1) {
            return false;
        }
        if (n == this.getNumberOfRegions() - 1) {
            return false;
        }
        boolean bl = false;
        double d2 = d - this.getStart(n) + 0.001;
        double d3 = this.getEnd(n + 1) - d + 0.001;
        if (d2 >= this._minRegionWidth && d3 >= this._minRegionWidth) {
            this.setNotifyEnabled(false);
            this.setEnd(n, d);
            this.setStart(n + 1, d);
            this.validateRegions();
            this.setNotifyEnabled(true);
            bl = true;
        }
        return bl;
    }

    public boolean isInWell(double d) {
        int n;
        boolean bl = false;
        int n2 = this.getNumberOfRegions();
        if (n2 > 2 && (n = this.getRegionIndexAt(d)) > 0 && n < n2 - 1) {
            int n3;
            double d2 = this.getEnergy(n);
            boolean bl2 = false;
            for (n3 = 0; n3 < n; ++n3) {
                double d3 = this.getEnergy(n3);
                if (!(d3 > d2)) continue;
                bl2 = true;
                break;
            }
            n3 = 0;
            for (int i = n + 1; i < n2; ++i) {
                double d4 = this.getEnergy(i);
                if (!(d4 > d2)) continue;
                n3 = 1;
                break;
            }
            bl = bl2 && n3 != 0;
        }
        return bl;
    }

    public double getTopOfWellAt(double d) {
        double d2;
        assert (this.isInWell(d));
        int n = this.getNumberOfRegions();
        int n2 = this.getRegionIndexAt(d);
        double d3 = d2 = this.getEnergy(n2);
        for (int i = n2 - 1; i >= 0; --i) {
            double d4 = this.getEnergy(i);
            if (!(d4 > d2)) continue;
            if (!(d4 > d3)) break;
            d3 = d4;
        }
        double d5 = d2;
        for (int i = n2 + 1; i < n; ++i) {
            double d6 = this.getEnergy(i);
            if (!(d6 > d2)) continue;
            if (!(d6 > d5)) break;
            d5 = d6;
        }
        return Math.min(d3, d5);
    }

    public boolean isInFirstRegion(double d) {
        int n = this.getRegionIndexAt(d);
        return n == 0;
    }

    public boolean isInLastRegion(double d) {
        int n = this.getRegionIndexAt(d);
        return n == this.getNumberOfRegions() - 1;
    }

    private PotentialRegion getRegion(int n) {
        this.validateRegionIndex(n);
        return this._regions[n];
    }

    protected void setRegion(int n, double d, double d2, double d3) {
        this.validateRegionIndex(n);
        this._regions[n] = new PotentialRegion(d, d2, d3);
        this.notifyObservers();
    }

    protected void setRegion(int n, double d, double d2) {
        this.validateRegionIndex(n);
        double d3 = this.getRegion(n).getEnergy();
        this.setRegion(n, d, d2, d3);
    }

    protected void setStart(int n, double d) {
        this.validateRegionIndex(n);
        double d2 = this.getRegion(n).getEnd();
        double d3 = this.getRegion(n).getEnergy();
        this.setRegion(n, d, d2, d3);
    }

    protected void setEnd(int n, double d) {
        this.validateRegionIndex(n);
        double d2 = this.getRegion(n).getStart();
        double d3 = this.getRegion(n).getEnergy();
        this.setRegion(n, d2, d, d3);
    }

    private Range getPositionRangeReference() {
        return QTConstants.POSITION_RANGE;
    }

    private void validateRegionIndex(int n) {
        if (n < 0 || n > this._regions.length - 1) {
            throw new IndexOutOfBoundsException("regionIndex out of bounds: " + n);
        }
    }

    protected void validateRegions() {
        int n = 0;
        for (int i = 1; i < this._regions.length - 1; ++i) {
            String string;
            if (this._regions[i].getEnd() != this._regions[i + 1].getStart()) {
                ++n;
                string = "ERROR: regions " + i + " and " + (i + 1) + " are not contiguous: " + this._regions[i].getEnd() + " != " + this._regions[i + 1].getStart();
                System.err.println(string);
            }
            if (!(this._regions[i].getWidth() + 0.001 < this._minRegionWidth)) continue;
            ++n;
            string = "ERROR: region " + i + " is smaller than the minimum width: " + this._regions[i].getWidth() + " < " + this._minRegionWidth;
            System.err.println(string);
        }
        if (n != 0) {
            IllegalStateException illegalStateException = new IllegalStateException("potential space is invalid");
            illegalStateException.printStackTrace();
        }
    }
}

