/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.quantumtunneling.QTResources;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class ZoomControl
extends JPanel {
    private static final Insets MARGIN = new Insets(0, 0, 0, 0);
    private int _orientation;
    private ArrayList _plots;
    private ZoomSpec[] _specs;
    private int _zoomIndex;
    JButton _zoomInButton;
    JButton _zoomOutButton;

    public ZoomControl(int n, ZoomSpec[] zoomSpecArray, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        if (n2 < 0 || n2 > zoomSpecArray.length - 1) {
            throw new IndexOutOfBoundsException("startingIndex out of bounds: " + n2);
        }
        this.setOpaque(false);
        this._orientation = n;
        this._plots = new ArrayList();
        this._specs = zoomSpecArray;
        this._zoomIndex = n2;
        ImageIcon imageIcon = new ImageIcon(QTResources.getImage("zoomIn.gif"));
        this._zoomInButton = new JButton(imageIcon);
        ImageIcon imageIcon2 = new ImageIcon(QTResources.getImage("zoomOut.gif"));
        this._zoomOutButton = new JButton(imageIcon2);
        this._zoomInButton.setOpaque(true);
        this._zoomInButton.setMargin(MARGIN);
        this._zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomControl.this.handleZoomIn();
            }
        });
        this._zoomOutButton.setOpaque(true);
        this._zoomOutButton.setMargin(MARGIN);
        this._zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZoomControl.this.handleZoomOut();
            }
        });
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        if (n == 0) {
            easyGridBagLayout.setInsets(new Insets(0, 0, 0, 2));
            easyGridBagLayout.addComponent(this._zoomInButton, 0, 0);
            easyGridBagLayout.addComponent(this._zoomOutButton, 0, 1);
        } else {
            easyGridBagLayout.setInsets(new Insets(0, 0, 2, 0));
            easyGridBagLayout.addComponent(this._zoomInButton, 0, 0);
            easyGridBagLayout.addComponent(this._zoomOutButton, 1, 0);
        }
        this.setRange(this._zoomIndex);
    }

    public void addPlot(XYPlot xYPlot) {
        if (!this._plots.contains(xYPlot)) {
            this._plots.add(xYPlot);
        }
    }

    public int getZoomIndex() {
        return this._zoomIndex;
    }

    public void setZoomIndex(int n) {
        if (n < 0 || n > this._specs.length - 1) {
            this._zoomIndex = 0;
            System.err.println("WARNING: zoom index out of range: " + n);
        } else {
            this._zoomIndex = n;
        }
        this.setRange(this._zoomIndex);
    }

    private void handleZoomIn() {
        --this._zoomIndex;
        this.setRange(this._zoomIndex);
    }

    private void handleZoomOut() {
        ++this._zoomIndex;
        this.setRange(this._zoomIndex);
    }

    private void setRange(int n) {
        ZoomSpec zoomSpec = this._specs[n];
        Range range = zoomSpec.getRange();
        double d = zoomSpec.getTickSpacing();
        String string = zoomSpec.getTickPattern();
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(d, new DecimalFormat(string)));
        for (XYPlot xYPlot : this._plots) {
            if (this._orientation == 0) {
                xYPlot.getDomainAxis().setRange(range);
                xYPlot.getDomainAxis().setStandardTickUnits(tickUnits);
                continue;
            }
            xYPlot.getRangeAxis().setRange(range);
            xYPlot.getRangeAxis().setStandardTickUnits(tickUnits);
        }
        this._zoomInButton.setEnabled(n > 0);
        this._zoomOutButton.setEnabled(n < this._specs.length - 1);
    }

    public static class ZoomSpec {
        private Range _range;
        private double _tickSpacing;
        private String _tickPattern;

        public ZoomSpec(Range range, double d, String string) {
            this._range = new Range(range.getLowerBound(), range.getUpperBound());
            this._tickSpacing = d;
            this._tickPattern = string;
        }

        public Range getRange() {
            return this._range;
        }

        public double getTickSpacing() {
            return this._tickSpacing;
        }

        public String getTickPattern() {
            return this._tickPattern;
        }
    }
}

