/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.color.QTColorScheme;
import edu.colorado.phet.quantumtunneling.control.PotentialComboBox;
import edu.colorado.phet.quantumtunneling.control.QTAbstractControlPanel;
import edu.colorado.phet.quantumtunneling.control.SliderControl;
import edu.colorado.phet.quantumtunneling.enums.Direction;
import edu.colorado.phet.quantumtunneling.enums.IRView;
import edu.colorado.phet.quantumtunneling.enums.PotentialType;
import edu.colorado.phet.quantumtunneling.enums.WaveType;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.model.PotentialFactory;
import edu.colorado.phet.quantumtunneling.module.QTModule;
import edu.colorado.phet.quantumtunneling.view.ViewLegend;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QTControlPanel
extends QTAbstractControlPanel {
    private QTModule _module;
    private PotentialComboBox _potentialComboBox;
    private JCheckBox _showValuesCheckBox;
    private JCheckBox _rtpCheckBox;
    private JCheckBox _realCheckBox;
    private JCheckBox _imaginaryCheckBox;
    private JCheckBox _magnitudeCheckBox;
    private JCheckBox _phaseCheckBox;
    private JLabel _realLegend;
    private JLabel _imaginaryLegend;
    private JLabel _magnitudeLegend;
    private JLabel _phaseLegend;
    private JPanel _irPanel;
    private JRadioButton _separateRadioButton;
    private JRadioButton _sumRadioButton;
    private JRadioButton _leftToRightRadioButton;
    private JRadioButton _rightToLeftRadioButton;
    private JRadioButton _planeWaveRadioButton;
    private JRadioButton _wavePacketRadioButton;
    private JPanel _propertiesPanel;
    private SliderControl _widthSlider;
    private SliderControl _centerSlider;
    private EventListener _listener;

    public QTControlPanel(QTModule qTModule) {
        super(qTModule);
        this._module = qTModule;
        int n = QTResources.getInt("width.controlPanel", 235);
        this.setMinimumWidth(n);
        JPanel jPanel = new JPanel();
        JComponent jComponent = new JLabel(QTResources.getString("label.potential"));
        this._potentialComboBox = new PotentialComboBox();
        this._showValuesCheckBox = new JCheckBox(QTResources.getString("label.showValues"));
        JPanel jPanel2 = new JPanel();
        Serializable serializable = new EasyGridBagLayout(jPanel2);
        jPanel2.setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).setMinimumWidth(0, 0);
        ((EasyGridBagLayout)serializable).addComponent(jComponent, 0, 1);
        ((EasyGridBagLayout)serializable).addComponent(this._potentialComboBox, 1, 1);
        ((EasyGridBagLayout)serializable).addComponent(this._showValuesCheckBox, 2, 1);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jComponent = new JPanel();
        this._rtpCheckBox = new JCheckBox(QTResources.getString("label.rtProbability"));
        jPanel2 = new JPanel();
        serializable = new EasyGridBagLayout(jPanel2);
        jPanel2.setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).setMinimumWidth(0, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._rtpCheckBox, 0, 1);
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)jPanel2, "West");
        jPanel2 = new JPanel();
        serializable = new JLabel(QTResources.getString("label.view"));
        this._realCheckBox = new JCheckBox(QTResources.getString("choice.view.real"));
        this._imaginaryCheckBox = new JCheckBox(QTResources.getString("choice.view.imaginary"));
        this._magnitudeCheckBox = new JCheckBox(QTResources.getString("choice.view.magnitude"));
        this._phaseCheckBox = new JCheckBox(QTResources.getString("choice.view.phase"));
        JComponent jComponent2 = new JPanel(new FlowLayout(0, 0, 0));
        jComponent2.add(this._realCheckBox);
        jComponent2.add(Box.createHorizontalStrut(7));
        Object object = ViewLegend.createColorKey(QTConstants.COLOR_SCHEME.getRealColor());
        this._realLegend = new JLabel((Icon)object);
        jComponent2.add(this._realLegend);
        Serializable serializable2 = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)serializable2).add(this._imaginaryCheckBox);
        ((Container)serializable2).add(Box.createHorizontalStrut(7));
        Object object2 = ViewLegend.createColorKey(QTConstants.COLOR_SCHEME.getImaginaryColor());
        this._imaginaryLegend = new JLabel((Icon)object2);
        ((Container)serializable2).add(this._imaginaryLegend);
        Serializable serializable3 = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)serializable3).add(this._magnitudeCheckBox);
        ((Container)serializable3).add(Box.createHorizontalStrut(7));
        Object object3 = ViewLegend.createColorKey(QTConstants.COLOR_SCHEME.getMagnitudeColor());
        this._magnitudeLegend = new JLabel((Icon)object3);
        ((Container)serializable3).add(this._magnitudeLegend);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(this._phaseCheckBox);
        jPanel3.add(Box.createHorizontalStrut(7));
        Object object4 = ViewLegend.createPhaseKey();
        this._phaseLegend = new JLabel((Icon)object4);
        jPanel3.add(this._phaseLegend);
        JPanel jPanel4 = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel4);
        jPanel4.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setMinimumWidth(0, 0);
        easyGridBagLayout.addComponent((Component)serializable, 0, 1);
        easyGridBagLayout.addComponent(jComponent2, 1, 1);
        easyGridBagLayout.addComponent((Component)serializable2, 2, 1);
        easyGridBagLayout.addComponent((Component)serializable3, 3, 1);
        easyGridBagLayout.addComponent(jPanel3, 4, 1);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel4, "West");
        serializable = new JPanel();
        jComponent2 = new JLabel(QTResources.getString("label.direction"));
        object = new ImageIcon(QTResources.getImage("arrowL2R.png"));
        serializable2 = new ImageIcon(QTResources.getImage("arrowR2L.png"));
        object2 = new ImageIcon(QTResources.getImage("arrowL2RSelected.png"));
        serializable3 = new ImageIcon(QTResources.getImage("arrowR2LSelected.png"));
        this._leftToRightRadioButton = new JRadioButton((Icon)object);
        this._leftToRightRadioButton.setSelectedIcon((Icon)object2);
        this._rightToLeftRadioButton = new JRadioButton((Icon)((Object)serializable2));
        this._rightToLeftRadioButton.setSelectedIcon((Icon)((Object)serializable3));
        object3 = new ButtonGroup();
        ((ButtonGroup)object3).add(this._leftToRightRadioButton);
        ((ButtonGroup)object3).add(this._rightToLeftRadioButton);
        jPanel3 = new JPanel();
        object4 = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout((LayoutManager)object4);
        ((EasyGridBagLayout)object4).setAnchor(17);
        ((EasyGridBagLayout)object4).addComponent(this._leftToRightRadioButton, 0, 0);
        ((EasyGridBagLayout)object4).addComponent(this._rightToLeftRadioButton, 0, 1);
        jPanel4 = new JPanel();
        easyGridBagLayout = new EasyGridBagLayout(jPanel4);
        jPanel4.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setMinimumWidth(0, 0);
        easyGridBagLayout.addComponent(jComponent2, 0, 1);
        easyGridBagLayout.addComponent(jPanel3, 1, 1);
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add(jPanel4, "West");
        jComponent2 = new JPanel();
        object = new JLabel(QTResources.getString("label.wave"));
        this._wavePacketRadioButton = new JRadioButton(QTResources.getString("choice.wave.packet"));
        this._planeWaveRadioButton = new JRadioButton(QTResources.getString("choice.wave.plane"));
        serializable2 = new ButtonGroup();
        ((ButtonGroup)serializable2).add(this._wavePacketRadioButton);
        ((ButtonGroup)serializable2).add(this._planeWaveRadioButton);
        object2 = new JPanel();
        serializable3 = new EasyGridBagLayout((JPanel)object2);
        ((Container)object2).setLayout((LayoutManager)((Object)serializable3));
        ((EasyGridBagLayout)serializable3).setAnchor(17);
        ((EasyGridBagLayout)serializable3).setMinimumWidth(0, 0);
        ((EasyGridBagLayout)serializable3).addComponent((Component)object, 0, 1);
        ((EasyGridBagLayout)serializable3).addComponent(this._wavePacketRadioButton, 1, 1);
        ((EasyGridBagLayout)serializable3).addComponent(this._planeWaveRadioButton, 2, 1);
        jComponent2.setLayout(new BorderLayout());
        jComponent2.add((Component)object2, "West");
        this._propertiesPanel = new JPanel();
        object = new JLabel(QTResources.getString("label.packetProperties"));
        this._widthSlider = new SliderControl(0.1, 4.0, 1.0, 1, 1, QTResources.getString("label.packetWidth") + " {0} " + QTResources.getString("units.position"), new Insets(5, 0, 0, 0));
        this._widthSlider.setInverted(true);
        this._centerSlider = new SliderControl(QTConstants.MIN_PACKET_CENTER, QTConstants.MAX_PACKET_CENTER, 4.0, 0, 1, QTResources.getString("label.packetCenter") + " {0} " + QTResources.getString("units.position"), new Insets(0, 0, 0, 0));
        serializable2 = new JPanel();
        object2 = new EasyGridBagLayout((JPanel)serializable2);
        ((Container)serializable2).setLayout((LayoutManager)object2);
        ((EasyGridBagLayout)object2).setAnchor(17);
        ((EasyGridBagLayout)object2).setMinimumWidth(0, 0);
        ((EasyGridBagLayout)object2).addComponent((Component)object, 0, 1);
        ((EasyGridBagLayout)object2).addComponent(this._widthSlider, 1, 1);
        ((EasyGridBagLayout)object2).addComponent(this._centerSlider, 2, 1);
        this._propertiesPanel.setLayout(new BorderLayout());
        this._propertiesPanel.add((Component)serializable2, "West");
        this._irPanel = new JPanel();
        object = new JLabel(QTResources.getString("label.ir"));
        this._sumRadioButton = new JRadioButton(QTResources.getString("choice.ir.sum"));
        this._separateRadioButton = new JRadioButton(QTResources.getString("choice.ir.separate"));
        serializable2 = new ButtonGroup();
        ((ButtonGroup)serializable2).add(this._sumRadioButton);
        ((ButtonGroup)serializable2).add(this._separateRadioButton);
        int n2 = 10;
        serializable3 = new JPanel();
        object3 = new EasyGridBagLayout((JPanel)serializable3);
        ((Container)serializable3).setLayout((LayoutManager)object3);
        ((EasyGridBagLayout)object3).setAnchor(17);
        ((EasyGridBagLayout)object3).setMinimumWidth(1, n2);
        ((EasyGridBagLayout)object3).addComponent(this._sumRadioButton, 0, 0);
        ((EasyGridBagLayout)object3).addComponent(this._separateRadioButton, 0, 2);
        jPanel3 = new JPanel();
        object4 = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout((LayoutManager)object4);
        ((EasyGridBagLayout)object4).setAnchor(17);
        ((EasyGridBagLayout)object4).setMinimumWidth(0, 0);
        ((EasyGridBagLayout)object4).addComponent((Component)object, 0, 1);
        ((EasyGridBagLayout)object4).addComponent((Component)serializable3, 1, 1);
        this._irPanel.setLayout(new BorderLayout());
        this._irPanel.add((Component)jPanel3, "West");
        this.addControlFullWidth(jPanel);
        this.addVerticalSpace(0);
        this.addSeparator();
        this.addControlFullWidth(jComponent);
        this.addVerticalSpace(0);
        this.addSeparator();
        this.addControlFullWidth(jPanel2);
        this.addVerticalSpace(0);
        this.addSeparator();
        this.addControlFullWidth((Component)serializable);
        this.addVerticalSpace(0);
        this.addSeparator();
        this.addControlFullWidth(jComponent2);
        this.addVerticalSpace(0);
        this.addSeparator();
        this.addControlFullWidth(this._propertiesPanel);
        this.addControlFullWidth(this._irPanel);
        this.addVerticalSpace(0);
        this.addSeparator();
        this.addResetAllButton(qTModule);
        this._listener = new EventListener();
        this._potentialComboBox.addItemListener(this._listener);
        this._showValuesCheckBox.addActionListener(this._listener);
        this._rtpCheckBox.addActionListener(this._listener);
        this._realCheckBox.addActionListener(this._listener);
        this._imaginaryCheckBox.addActionListener(this._listener);
        this._magnitudeCheckBox.addActionListener(this._listener);
        this._phaseCheckBox.addActionListener(this._listener);
        this._separateRadioButton.addActionListener(this._listener);
        this._sumRadioButton.addActionListener(this._listener);
        this._leftToRightRadioButton.addActionListener(this._listener);
        this._rightToLeftRadioButton.addActionListener(this._listener);
        this._planeWaveRadioButton.addActionListener(this._listener);
        this._wavePacketRadioButton.addActionListener(this._listener);
        this._widthSlider.addChangeListener(this._listener);
        this._centerSlider.addChangeListener(this._listener);
    }

    public void setColorScheme(QTColorScheme qTColorScheme) {
        this._potentialComboBox.removeItemListener(this._listener);
        this._potentialComboBox.setPotentialColor(qTColorScheme.getPotentialEnergyColor());
        this._potentialComboBox.addItemListener(this._listener);
        this._realLegend.setIcon(ViewLegend.createColorKey(qTColorScheme.getRealColor()));
        this._imaginaryLegend.setIcon(ViewLegend.createColorKey(qTColorScheme.getImaginaryColor()));
        this._magnitudeLegend.setIcon(ViewLegend.createColorKey(qTColorScheme.getMagnitudeColor()));
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential) {
        this._potentialComboBox.removeItemListener(this._listener);
        PotentialType potentialType = PotentialFactory.getPotentialType(abstractPotential);
        this._potentialComboBox.setSelectedPotentialType(potentialType);
        this._potentialComboBox.addItemListener(this._listener);
    }

    public void setPotentialType(PotentialType potentialType) {
        this._potentialComboBox.setSelectedPotentialType(potentialType);
        this.handlePotentialSelection();
    }

    public PotentialType getPotentialType() {
        return this._potentialComboBox.getSelectedPotentialType();
    }

    public void setShowValuesSelected(boolean bl) {
        this._showValuesCheckBox.setSelected(bl);
        this.handleShowValuesSelection();
    }

    public boolean isShowValuesSelected() {
        return this._showValuesCheckBox.isSelected();
    }

    public void setRtpSelected(boolean bl) {
        this._rtpCheckBox.setSelected(bl);
        this.handleRtpSelection();
    }

    public boolean isRtpSelected() {
        return this._rtpCheckBox.isSelected();
    }

    public void setRealSelected(boolean bl) {
        this._realCheckBox.setSelected(bl);
        this.handleRealSelection();
    }

    public boolean isRealSelected() {
        return this._realCheckBox.isSelected();
    }

    public void setImaginarySelected(boolean bl) {
        this._imaginaryCheckBox.setSelected(bl);
        this.handleImaginarySelection();
    }

    public boolean isImaginarySelected() {
        return this._imaginaryCheckBox.isSelected();
    }

    public void setMagnitudeSelected(boolean bl) {
        this._magnitudeCheckBox.setSelected(bl);
        this.handleMagnitudeSelection();
    }

    public boolean isMagnitudeSelected() {
        return this._magnitudeCheckBox.isSelected();
    }

    public void setPhaseSelected(boolean bl) {
        this._phaseCheckBox.setSelected(bl);
        this.handlePhaseSelection();
    }

    public boolean isPhaseSelected() {
        return this._phaseCheckBox.isSelected();
    }

    public void setIRView(IRView iRView) {
        this._separateRadioButton.setSelected(iRView == IRView.SEPARATE);
        this._sumRadioButton.setSelected(iRView == IRView.SUM);
        this.handleIRViewSelection();
    }

    public IRView getIRView() {
        if (this._separateRadioButton.isSelected()) {
            return IRView.SEPARATE;
        }
        return IRView.SUM;
    }

    public void setDirection(Direction direction) {
        this._leftToRightRadioButton.setSelected(direction == Direction.LEFT_TO_RIGHT);
        this._rightToLeftRadioButton.setSelected(direction == Direction.RIGHT_TO_LEFT);
        this.handleDirectionSelection();
    }

    public Direction getDirection() {
        if (this._leftToRightRadioButton.isSelected()) {
            return Direction.LEFT_TO_RIGHT;
        }
        return Direction.RIGHT_TO_LEFT;
    }

    public void setWaveType(WaveType waveType) {
        this._planeWaveRadioButton.setSelected(waveType == WaveType.PLANE);
        this._wavePacketRadioButton.setSelected(waveType == WaveType.PACKET);
        this.handleWaveTypeSelection();
    }

    public WaveType getWaveType() {
        if (this._planeWaveRadioButton.isSelected()) {
            return WaveType.PLANE;
        }
        return WaveType.PACKET;
    }

    public void setPacketWidth(double d) {
        this._widthSlider.setValue(d);
        this.handleWidthSlider();
    }

    public double getPacketWidth() {
        return this._widthSlider.getValue();
    }

    public void setPacketCenter(double d) {
        this._centerSlider.setValue(d);
        this.handleCenterSlider();
    }

    public double getPacketCenter() {
        return this._centerSlider.getValue();
    }

    private void handlePotentialSelection() {
        this._module.setPotentialType(this.getPotentialType());
    }

    private void handleShowValuesSelection() {
        this._module.setValuesVisible(this._showValuesCheckBox.isSelected());
    }

    private void handleRealSelection() {
        this._module.setRealVisible(this._realCheckBox.isSelected());
    }

    private void handleImaginarySelection() {
        this._module.setImaginaryVisible(this._imaginaryCheckBox.isSelected());
    }

    private void handleMagnitudeSelection() {
        this._module.setMagnitudeVisible(this._magnitudeCheckBox.isSelected());
    }

    private void handlePhaseSelection() {
        this._module.setPhaseVisible(this._phaseCheckBox.isSelected());
    }

    private void handleIRViewSelection() {
        this._module.setIRView(this.getIRView());
        if (this.getWaveType() == WaveType.PLANE) {
            if (this.getIRView() == IRView.SEPARATE) {
                this._phaseCheckBox.setEnabled(false);
                this.handlePhaseSelection();
            } else {
                this._phaseCheckBox.setEnabled(true);
                this.handlePhaseSelection();
            }
        }
    }

    private void handleDirectionSelection() {
        this._module.setDirection(this.getDirection());
    }

    private void handleWaveTypeSelection() {
        if (this.getWaveType() == WaveType.PLANE) {
            this._phaseCheckBox.setEnabled(this.getIRView() == IRView.SUM);
            this._propertiesPanel.setVisible(false);
            this._irPanel.setVisible(true);
            this._module.setWaveType(WaveType.PLANE);
        } else {
            this._phaseCheckBox.setEnabled(true);
            this._propertiesPanel.setVisible(true);
            this._irPanel.setVisible(false);
            this._module.setWaveType(WaveType.PACKET);
        }
    }

    private void handleWidthSlider() {
        double d = this._widthSlider.getValue();
        this._module.setWavePacketWidth(d);
    }

    private void handleCenterSlider() {
        double d = this._centerSlider.getValue();
        this._module.setWavePacketCenter(d);
    }

    private void handleRtpSelection() {
        this._module.setRtpVisible(this._rtpCheckBox.isSelected());
    }

    private class EventListener
    implements ActionListener,
    ItemListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == QTControlPanel.this._showValuesCheckBox) {
                QTControlPanel.this.handleShowValuesSelection();
            } else if (object == QTControlPanel.this._rtpCheckBox) {
                QTControlPanel.this.handleRtpSelection();
            } else if (object == QTControlPanel.this._realCheckBox) {
                QTControlPanel.this.handleRealSelection();
            } else if (object == QTControlPanel.this._imaginaryCheckBox) {
                QTControlPanel.this.handleImaginarySelection();
            } else if (object == QTControlPanel.this._magnitudeCheckBox) {
                QTControlPanel.this.handleMagnitudeSelection();
            } else if (object == QTControlPanel.this._phaseCheckBox) {
                QTControlPanel.this.handlePhaseSelection();
            } else if (object == QTControlPanel.this._separateRadioButton || object == QTControlPanel.this._sumRadioButton) {
                QTControlPanel.this.handleIRViewSelection();
            } else if (object == QTControlPanel.this._leftToRightRadioButton || object == QTControlPanel.this._rightToLeftRadioButton) {
                QTControlPanel.this.handleDirectionSelection();
            } else if (object == QTControlPanel.this._planeWaveRadioButton || object == QTControlPanel.this._wavePacketRadioButton) {
                QTControlPanel.this.handleWaveTypeSelection();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == QTControlPanel.this._widthSlider) {
                QTControlPanel.this.handleWidthSlider();
            } else if (object == QTControlPanel.this._centerSlider) {
                QTControlPanel.this.handleCenterSlider();
            } else {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == QTControlPanel.this._potentialComboBox) {
                    QTControlPanel.this.handlePotentialSelection();
                } else {
                    throw new IllegalArgumentException("unexpected event: " + itemEvent);
                }
            }
        }
    }
}

