/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.quantumtunneling.QTConstants;
import edu.colorado.phet.quantumtunneling.control.AbstractDragHandle;
import edu.colorado.phet.quantumtunneling.model.AbstractPotential;
import edu.colorado.phet.quantumtunneling.view.QTCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;

public class PotentialEnergyDragHandle
extends AbstractDragHandle
implements PropertyChangeListener,
Observer {
    private AbstractPotential _potentialEnergy;
    private int _regionIndex;
    private QTCombinedChartNode _chartNode;

    public PotentialEnergyDragHandle(QTCombinedChartNode qTCombinedChartNode) {
        super(1);
        this.setValueFormat("0.00");
        this._potentialEnergy = null;
        this._regionIndex = -1;
        this._chartNode = qTCombinedChartNode;
        this.addPropertyChangeListener(this);
        this.updateDragBounds();
    }

    public void cleanup() {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
            this._potentialEnergy = null;
        }
    }

    public void setPotentialEnergy(AbstractPotential abstractPotential, int n) {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
        }
        this._regionIndex = n;
        this._potentialEnergy = abstractPotential;
        this._potentialEnergy.addObserver(this);
        this.updatePosition();
        this.updateText();
    }

    public void updateDragBounds() {
        Point2D point2D = this._chartNode.energyToNode(new Point2D.Double(QTConstants.POSITION_RANGE.getLowerBound(), 0.0));
        Point2D point2D2 = this._chartNode.energyToNode(new Point2D.Double(QTConstants.POSITION_RANGE.getUpperBound(), 0.0));
        Point2D point2D3 = this._chartNode.energyToNode(new Point2D.Double(0.0, QTConstants.ENERGY_RANGE.getLowerBound()));
        Point2D point2D4 = this._chartNode.energyToNode(new Point2D.Double(0.0, QTConstants.ENERGY_RANGE.getUpperBound()));
        double d = point2D.getX();
        double d2 = point2D4.getY();
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D3.getY() - point2D4.getY();
        Rectangle2D rectangle2D = new Rectangle2D.Double(d, d2, d3, d4);
        rectangle2D = this._chartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updatePosition();
    }

    private void updatePosition() {
        if (this._potentialEnergy != null) {
            double d = this._potentialEnergy.getMiddle(this._regionIndex);
            double d2 = this._potentialEnergy.getEnergy(this._regionIndex);
            Point2D.Double double_ = new Point2D.Double(d, d2);
            Point2D point2D = this._chartNode.energyToNode(double_);
            Point2D point2D2 = this._chartNode.localToGlobal(point2D);
            this.removePropertyChangeListener(this);
            this.setGlobalPosition(point2D2);
            this.addPropertyChangeListener(this);
        }
    }

    protected double getModelValue() {
        double d = 0.0;
        if (this._potentialEnergy != null) {
            d = this._potentialEnergy.getEnergy(this._regionIndex);
        }
        return d;
    }

    protected void updateModel() {
        if (this._potentialEnergy != null) {
            this._potentialEnergy.deleteObserver(this);
            Point2D point2D = this.getGlobalPosition();
            Point2D point2D2 = this._chartNode.globalToLocal(point2D);
            Point2D point2D3 = this._chartNode.nodeToEnergy(point2D2);
            this._potentialEnergy.setEnergy(this._regionIndex, point2D3.getY());
            this._potentialEnergy.addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._potentialEnergy) {
            this.updateDragBounds();
            this.updateText();
        }
    }
}

