/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumtunneling.control;

import edu.colorado.phet.quantumtunneling.QTResources;
import edu.colorado.phet.quantumtunneling.enums.PotentialType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class PotentialComboBox
extends JComboBox {
    private static final Dimension ICON_SIZE = new Dimension(50, 20);
    private static final Stroke ICON_STROKE = new BasicStroke(2.0f);
    private Color _potentialColor = Color.BLACK;
    private ArrayList _choices;

    public PotentialComboBox() {
        this.initChoices();
        PotentialComboBoxRenderer potentialComboBoxRenderer = new PotentialComboBoxRenderer();
        this.setRenderer(potentialComboBoxRenderer);
    }

    private void initChoices() {
        if (this._choices == null) {
            this._choices = new ArrayList();
        } else {
            this._choices.clear();
        }
        ImageIcon imageIcon = PotentialComboBox.createConstantIcon(this._potentialColor);
        ImageIcon imageIcon2 = PotentialComboBox.createStepIcon(this._potentialColor);
        ImageIcon imageIcon3 = PotentialComboBox.createSingleBarrierIcon(this._potentialColor);
        ImageIcon imageIcon4 = PotentialComboBox.createDoubleBarrierIcon(this._potentialColor);
        PotentialChoice potentialChoice = new PotentialChoice(PotentialType.CONSTANT, QTResources.getString("choice.potential.constant"), imageIcon);
        PotentialChoice potentialChoice2 = new PotentialChoice(PotentialType.STEP, QTResources.getString("choice.potential.step"), imageIcon2);
        PotentialChoice potentialChoice3 = new PotentialChoice(PotentialType.SINGLE_BARRIER, QTResources.getString("choice.potential.barrier"), imageIcon3);
        PotentialChoice potentialChoice4 = new PotentialChoice(PotentialType.DOUBLE_BARRIER, QTResources.getString("choice.potential.double"), imageIcon4);
        this._choices.add(potentialChoice);
        this._choices.add(potentialChoice2);
        this._choices.add(potentialChoice3);
        this._choices.add(potentialChoice4);
        this.removeAllItems();
        Iterator iterator = this._choices.iterator();
        while (iterator.hasNext()) {
            this.addItem(iterator.next());
        }
        this.setMaximumRowCount(this._choices.size());
    }

    public void setPotentialColor(Color color) {
        this._potentialColor = color;
        PotentialType potentialType = this.getSelectedPotentialType();
        this.initChoices();
        this.setSelectedPotentialType(potentialType);
    }

    public PotentialType getSelectedPotentialType() {
        return ((PotentialChoice)this.getSelectedItem()).getPotentialType();
    }

    public void setSelectedPotentialType(PotentialType potentialType) {
        for (PotentialChoice potentialChoice : this._choices) {
            if (potentialChoice.getPotentialType() != potentialType) continue;
            this.setSelectedItem(potentialChoice);
            break;
        }
    }

    private static ImageIcon createConstantIcon(Color color) {
        int n = PotentialComboBox.ICON_SIZE.width;
        int n2 = PotentialComboBox.ICON_SIZE.height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2 / 2);
        generalPath.lineTo(n / 2, n2 / 2);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        return new ImageIcon(bufferedImage);
    }

    private static ImageIcon createStepIcon(Color color) {
        int n = PotentialComboBox.ICON_SIZE.width;
        int n2 = PotentialComboBox.ICON_SIZE.height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2 - 4);
        generalPath.lineTo(n / 3, n2 - 4);
        generalPath.lineTo(n / 3, 4.0f);
        generalPath.lineTo(2 * n / 3, 4.0f);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        return new ImageIcon(bufferedImage);
    }

    private static ImageIcon createSingleBarrierIcon(Color color) {
        int n = PotentialComboBox.ICON_SIZE.width;
        int n2 = PotentialComboBox.ICON_SIZE.height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2 - 4);
        generalPath.lineTo(n / 5, n2 - 4);
        generalPath.lineTo(n / 5, 4.0f);
        generalPath.lineTo(2 * n / 5, 4.0f);
        generalPath.lineTo(2 * n / 5, n2 - 4);
        generalPath.lineTo(3 * n / 5, n2 - 4);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        return new ImageIcon(bufferedImage);
    }

    private static ImageIcon createDoubleBarrierIcon(Color color) {
        int n = PotentialComboBox.ICON_SIZE.width;
        int n2 = PotentialComboBox.ICON_SIZE.height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n2 - 4);
        generalPath.lineTo(n / 5, n2 - 4);
        generalPath.lineTo(n / 5, 4.0f);
        generalPath.lineTo(2 * n / 5, 4.0f);
        generalPath.lineTo(2 * n / 5, n2 - 4);
        generalPath.lineTo(3 * n / 5, n2 - 4);
        generalPath.lineTo(3 * n / 5, 4.0f);
        generalPath.lineTo(4 * n / 5, 4.0f);
        generalPath.lineTo(4 * n / 5, n2 - 4);
        generalPath.lineTo(n, n2 - 4);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        return new ImageIcon(bufferedImage);
    }

    private static class PotentialChoice {
        private PotentialType _potentialType;
        private String _label;
        private ImageIcon _imageIcon;

        public PotentialChoice(PotentialType potentialType, String string, ImageIcon imageIcon) {
            this._potentialType = potentialType;
            this._label = string;
            this._imageIcon = imageIcon;
        }

        public PotentialType getPotentialType() {
            return this._potentialType;
        }

        public ImageIcon getImageIcon() {
            return this._imageIcon;
        }

        public String getLabel() {
            return this._label;
        }
    }

    private class PotentialComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public PotentialComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            PotentialChoice potentialChoice = (PotentialChoice)object;
            this.setText(potentialChoice.getLabel());
            this.setIcon(potentialChoice.getImageIcon());
            return this;
        }
    }
}

