/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util.persistence;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.Frame;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.swing.JFileChooser;

public class XMLPersistenceManager {
    private static final String SAVE_TITLE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.title");
    private static final String SAVE_CONFIRM_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.confirm.message");
    private static final String SAVE_ERROR_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.error.message");
    private static final String SAVE_ERROR_ENCODE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.save.error.encode");
    private static final String LOAD_TITLE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.title");
    private static final String LOAD_ERROR_MESSAGE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.error.message");
    private static final String LOAD_ERROR_DECODE = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.error.decode");
    private static final String LOAD_ERROR_CONTENTS = PhetCommonResources.getInstance().getLocalizedString("XMLPersistenceManager.load.error.contents");
    private ISaveLoadStrategy _saveLoadStrategy;

    public XMLPersistenceManager(Frame frame) {
        this._saveLoadStrategy = XMLPersistenceManager.wasWebStarted() ? new WebStartSaveLoadStrategy(frame) : new LocalSaveLoadStrategy(frame);
    }

    public void save(Object object) {
        this._saveLoadStrategy.save(object);
    }

    public Object load() {
        return this._saveLoadStrategy.load();
    }

    private static boolean wasWebStarted() {
        return System.getProperty("javawebstart.version") != null;
    }

    private static abstract class AbstractObjectSaveLoadStrategy
    implements ISaveLoadStrategy {
        private Frame _parentFrame;
        private String _mostRecentDirectoryName;

        public AbstractObjectSaveLoadStrategy(Frame frame) {
            this._parentFrame = frame;
            this._mostRecentDirectoryName = null;
        }

        protected Frame getParentFrame() {
            return this._parentFrame;
        }

        protected String getMostRecentDirectoryName() {
            return this._mostRecentDirectoryName;
        }

        protected void setMostRecentDirectoryName(String string) {
            this._mostRecentDirectoryName = string;
        }

        protected static String getDirectoryName(String string) {
            String string2 = null;
            int n = string.lastIndexOf(File.pathSeparatorChar);
            if (n != -1) {
                string2 = string.substring(n);
            }
            return string2;
        }

        protected void showError(String string, Exception exception) {
            this.showError(string, exception.getMessage());
            exception.printStackTrace();
        }

        protected void showError(String string, String string2) {
            Object[] objectArray = new Object[]{string2};
            String string3 = MessageFormat.format(string, objectArray);
            PhetOptionPane.showErrorDialog(this._parentFrame, string3);
        }
    }

    private static interface ISaveLoadStrategy {
        public void save(Object var1);

        public Object load();
    }

    private static class LocalSaveLoadStrategy
    extends AbstractObjectSaveLoadStrategy {
        public LocalSaveLoadStrategy(Frame frame) {
            super(frame);
        }

        public void save(Object object) {
            try {
                String string;
                JFileChooser jFileChooser = new JFileChooser(this.getMostRecentDirectoryName());
                jFileChooser.setDialogTitle(SAVE_TITLE);
                int n = jFileChooser.showSaveDialog(this.getParentFrame());
                this.setMostRecentDirectoryName(jFileChooser.getCurrentDirectory().getAbsolutePath());
                File file = jFileChooser.getSelectedFile();
                if (n == 1 || file == null) {
                    return;
                }
                this.setMostRecentDirectoryName(file.getParentFile().getAbsolutePath());
                if (file.exists()) {
                    string = PhetCommonResources.getInstance().getLocalizedString("Common.title.confirm");
                    int n2 = PhetOptionPane.showYesNoDialog(this.getParentFrame(), SAVE_CONFIRM_MESSAGE, string);
                    if (n2 != 0) {
                        return;
                    }
                }
                string = file.getAbsolutePath();
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                XMLEncoder xMLEncoder = new XMLEncoder(bufferedOutputStream);
                xMLEncoder.setExceptionListener(new ExceptionListener(){
                    private int errors = 0;

                    public void exceptionThrown(Exception exception) {
                        if (this.errors == 0) {
                            LocalSaveLoadStrategy.this.showError(SAVE_ERROR_ENCODE, exception);
                            ++this.errors;
                        }
                    }
                });
                xMLEncoder.writeObject(object);
                xMLEncoder.close();
            }
            catch (Exception exception) {
                this.showError(SAVE_ERROR_MESSAGE, exception);
            }
        }

        public Object load() {
            Object object = null;
            try {
                JFileChooser jFileChooser = new JFileChooser(this.getMostRecentDirectoryName());
                jFileChooser.setDialogTitle(LOAD_TITLE);
                int n = jFileChooser.showOpenDialog(this.getParentFrame());
                this.setMostRecentDirectoryName(jFileChooser.getCurrentDirectory().getAbsolutePath());
                File file = jFileChooser.getSelectedFile();
                if (n == 1 || file == null) {
                    return null;
                }
                String string = file.getAbsolutePath();
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                XMLDecoder xMLDecoder = new XMLDecoder(bufferedInputStream);
                xMLDecoder.setExceptionListener(new ExceptionListener(){
                    private int errors = 0;

                    public void exceptionThrown(Exception exception) {
                        if (this.errors == 0) {
                            LocalSaveLoadStrategy.this.showError(LOAD_ERROR_DECODE, exception);
                            ++this.errors;
                        }
                    }
                });
                object = xMLDecoder.readObject();
                xMLDecoder.close();
                if (object == null) {
                    this.showError(LOAD_ERROR_MESSAGE, LOAD_ERROR_CONTENTS);
                }
            }
            catch (Exception exception) {
                this.showError(LOAD_ERROR_MESSAGE, exception);
                object = null;
            }
            return object;
        }
    }

    private static class WebStartSaveLoadStrategy
    extends AbstractObjectSaveLoadStrategy {
        public WebStartSaveLoadStrategy(Frame frame) {
            super(frame);
        }

        public void save(Object object) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XMLEncoder xMLEncoder = new XMLEncoder(byteArrayOutputStream);
                xMLEncoder.setExceptionListener(new ExceptionListener(){
                    private int errors = 0;

                    public void exceptionThrown(Exception exception) {
                        if (this.errors == 0) {
                            WebStartSaveLoadStrategy.this.showError(SAVE_ERROR_ENCODE, exception);
                            ++this.errors;
                        }
                    }
                });
                xMLEncoder.writeObject(object);
                xMLEncoder.close();
                if (object == null) {
                    this.showError(SAVE_ERROR_MESSAGE, "XML encoding failer");
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                FileSaveService fileSaveService = (FileSaveService)ServiceManager.lookup("javax.jnlp.FileSaveService");
                if (fileSaveService == null) {
                    this.showError(SAVE_ERROR_MESSAGE, "JNLP FileSaveService is unavailable");
                    return;
                }
                FileContents fileContents = fileSaveService.saveFileDialog(null, null, byteArrayInputStream, this.getMostRecentDirectoryName());
                if (fileContents != null) {
                    this.setMostRecentDirectoryName(WebStartSaveLoadStrategy.getDirectoryName(fileContents.getName()));
                }
            }
            catch (Exception exception) {
                this.showError(SAVE_ERROR_MESSAGE, exception);
            }
        }

        public Object load() {
            Object object = null;
            try {
                FileOpenService fileOpenService = (FileOpenService)ServiceManager.lookup("javax.jnlp.FileOpenService");
                if (fileOpenService == null) {
                    this.showError(LOAD_ERROR_MESSAGE, "JNLP FileOpenService is unavailable");
                    return null;
                }
                FileContents fileContents = fileOpenService.openFileDialog(this.getMostRecentDirectoryName(), null);
                if (fileContents == null) {
                    return null;
                }
                this.setMostRecentDirectoryName(WebStartSaveLoadStrategy.getDirectoryName(fileContents.getName()));
                InputStream inputStream = fileContents.getInputStream();
                XMLDecoder xMLDecoder = new XMLDecoder(inputStream);
                xMLDecoder.setExceptionListener(new ExceptionListener(){
                    private int errors = 0;

                    public void exceptionThrown(Exception exception) {
                        if (this.errors == 0) {
                            WebStartSaveLoadStrategy.this.showError(LOAD_ERROR_DECODE, exception);
                            ++this.errors;
                        }
                    }
                });
                object = xMLDecoder.readObject();
                xMLDecoder.close();
                if (object == null) {
                    this.showError(LOAD_ERROR_MESSAGE, LOAD_ERROR_CONTENTS);
                }
            }
            catch (Exception exception) {
                this.showError(LOAD_ERROR_MESSAGE, exception);
                object = null;
            }
            return object;
        }
    }
}

