/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.controls.valuecontrol;

import edu.colorado.phet.common.phetcommon.view.controls.HTMLLabel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractSlider;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Hashtable;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractValueControl
extends JPanel {
    private double _value;
    private double _majorTickSpacing;
    private double _minorTickSpacing;
    private double _upDownArrowDelta;
    private AbstractSlider _slider;
    private JFormattedTextField _textField;
    private HTMLLabel _valueLabel;
    private HTMLLabel _unitsLabel;
    private Font _font;
    private NumberFormat _textFieldFormat;
    private DecimalFormat _tickFormat;
    private boolean _majorTicksVisible;
    private boolean _minorTicksVisible;
    private Hashtable _labelTable;
    private boolean _notifyWhileAdjusting;
    private boolean _isAdjusting;
    private EventListenerList _listenerList;
    private TextFieldListener _textFieldListener;
    private SliderListener _sliderListener;
    private boolean _initialized;
    private boolean _paintTickLabels;
    private boolean _signifyOutOfBounds;

    public AbstractValueControl(AbstractSlider abstractSlider, String string, String string2, String string3, ILayoutStrategy iLayoutStrategy) {
        this._slider = abstractSlider;
        this._majorTickSpacing = this._slider.getModelRange();
        this._minorTickSpacing = 0.0;
        this._upDownArrowDelta = this._slider.getModelRange() / 100.0;
        this._slider.setUpDownArrowDelta(this._upDownArrowDelta);
        this._textFieldFormat = new DecimalFormat(string2);
        this._tickFormat = new DecimalFormat(string2);
        this._majorTicksVisible = true;
        this._minorTicksVisible = false;
        this._labelTable = null;
        this._paintTickLabels = true;
        this._signifyOutOfBounds = true;
        this._notifyWhileAdjusting = true;
        this._isAdjusting = false;
        this._font = new PhetFont();
        this._listenerList = new EventListenerList();
        this._valueLabel = new HTMLLabel(string);
        this._unitsLabel = new HTMLLabel(string3);
        this._textField = new JFormattedTextField(this._textFieldFormat);
        this._textField.setValue(new Double(this._value));
        this._textField.setHorizontalAlignment(4);
        this._textField.setColumns(string2.length());
        iLayoutStrategy.doLayout(this);
        this._sliderListener = new SliderListener();
        this._slider.addChangeListener(this._sliderListener);
        this._textFieldListener = new TextFieldListener();
        this._textField.addActionListener(this._textFieldListener);
        this._textField.addFocusListener(this._textFieldListener);
        this._textField.addKeyListener(this._textFieldListener);
        this.updateTickLabels();
        this._value = this._slider.getModelMin() - 1.0;
        this.setValue(abstractSlider.getModelValue());
        this._initialized = true;
    }

    public AbstractSlider getSlider() {
        return this._slider;
    }

    public JFormattedTextField getTextField() {
        return this._textField;
    }

    public JLabel getValueLabel() {
        return this._valueLabel;
    }

    public JLabel getUnitsLabel() {
        return this._unitsLabel;
    }

    public void setValue(double d) {
        if (d != this._value) {
            this.setValue(d, true);
        }
    }

    private void setValue(double d, boolean bl) {
        if (this.isValueInRange(d)) {
            this._value = d;
            this.updateView();
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
        } else {
            if (this._signifyOutOfBounds) {
                Toolkit.getDefaultToolkit().beep();
                String string = this.getClass().getName() + ".setValue: ignoring invalid value for slider labeled \"" + this._valueLabel.getText() + "\", " + "range is " + this.getMinimum() + " to " + this.getMaximum() + ", tried to set " + d;
                new IllegalArgumentException(string).printStackTrace();
            }
            this.updateView();
        }
    }

    protected boolean isValueInRange(double d) {
        return d >= this.getMinimum() && d <= this.getMaximum();
    }

    public double getValue() {
        return this._value;
    }

    public double getMaximum() {
        return this._slider.getModelMax();
    }

    public double getMinimum() {
        return this._slider.getModelMin();
    }

    public void setUpDownArrowDelta(double d) {
        this._upDownArrowDelta = d;
        this._slider.setUpDownArrowDelta(d);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._valueLabel.setEnabled(bl);
        this._textField.setEnabled(bl);
        this._unitsLabel.setEnabled(bl);
        this._slider.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this._initialized) {
            this._font = font;
            this._valueLabel.setFont(font);
            this._textField.setFont(font);
            this._unitsLabel.setFont(font);
            this._slider.setFont(font);
            this.updateTickLabels();
        }
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this._valueLabel.setToolTipText(string);
        this._textField.setToolTipText(string);
        this._unitsLabel.setToolTipText(string);
        this._slider.setToolTipText(string);
    }

    public void setTextFieldEditable(boolean bl) {
        this._textField.setEditable(bl);
    }

    public void setTextFieldColumns(int n) {
        this._textField.setColumns(n);
    }

    private double getTextFieldValue() {
        String string = this._textField.getText();
        double d = 0.0;
        try {
            Number number = this._textFieldFormat.parse(string);
            d = number.doubleValue();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            d = this._value;
        }
        return d;
    }

    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    public void setNotifyWhileAdjusting(boolean bl) {
        this._notifyWhileAdjusting = bl;
    }

    public boolean getNotifyWhileAdjusting() {
        return this._notifyWhileAdjusting;
    }

    public void setMajorTickSpacing(double d) {
        if (d != this._minorTickSpacing) {
            this._majorTickSpacing = d;
            this.updateTickLabels();
        }
    }

    public void addTickLabel(double d, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this._font);
        this.addTickLabel(d, jLabel);
    }

    public void addTickLabel(double d, Object object) {
        if (this._labelTable == null) {
            this._labelTable = new Hashtable();
        }
        int n = this._slider.modelToSlider(d);
        this._labelTable.put(new Integer(n), object);
        this.updateTickLabels();
    }

    public void setSnapToTicks(boolean bl) {
        this._slider.setSnapToTicks(bl);
    }

    private void updateView() {
        this._slider.removeChangeListener(this._sliderListener);
        this._slider.setModelValue(this._value);
        this._slider.addChangeListener(this._sliderListener);
        this._textField.removeActionListener(this._textFieldListener);
        String string = this._textFieldFormat.format(this._value);
        this._textField.setText(string);
        this._textField.addActionListener(this._textFieldListener);
    }

    protected void updateTickLabels() {
        double d = this.getMinimum();
        double d2 = this.getMaximum();
        this._slider.setMajorTickSpacing(this._slider.modelToSlider(d + this._majorTickSpacing));
        if (this._minorTickSpacing > 0.0) {
            this._slider.setMinorTickSpacing(this._slider.modelToSlider(d + this._minorTickSpacing));
        }
        this._slider.setPaintTicks(this._minorTicksVisible || this._majorTicksVisible);
        this._slider.setPaintLabels((this._minorTicksVisible || this._majorTicksVisible) && this._paintTickLabels);
        if (this._labelTable != null) {
            this._slider.setLabelTable(this._labelTable);
        } else {
            JLabel jLabel;
            double d3;
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            if (this._majorTicksVisible) {
                for (d3 = d; d3 <= d2; d3 += this._majorTickSpacing) {
                    jLabel = new JLabel(this._tickFormat.format(d3));
                    jLabel.setFont(this._font);
                    hashtable.put(new Integer(this._slider.modelToSlider(d3)), jLabel);
                }
            }
            if (this._minorTicksVisible && this._minorTickSpacing > 0.0) {
                for (d3 = d + this._minorTickSpacing; d3 < d2; d3 += this._minorTickSpacing) {
                    jLabel = new JLabel(this._tickFormat.format(d3));
                    jLabel.setFont(this._font);
                    hashtable.put(new Integer(this._slider.modelToSlider(d3)), jLabel);
                }
            }
            if (hashtable.size() != 0) {
                this._slider.setLabelTable(hashtable);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == AbstractValueControl.this._slider) {
                AbstractValueControl.this._isAdjusting = AbstractValueControl.this._slider.getValueIsAdjusting();
                boolean bl = AbstractValueControl.this._notifyWhileAdjusting || !AbstractValueControl.this._isAdjusting;
                double d = AbstractValueControl.this._slider.getModelValue();
                AbstractValueControl.this.setValue(d, bl);
            }
        }
    }

    private class TextFieldListener
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private TextFieldListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == AbstractValueControl.this._textField) {
                double d;
                if (keyEvent.getKeyCode() == 38) {
                    double d2 = AbstractValueControl.this.getValue() + AbstractValueControl.this._upDownArrowDelta;
                    if (d2 <= AbstractValueControl.this.getMaximum()) {
                        AbstractValueControl.this.setValue(d2);
                    }
                } else if (keyEvent.getKeyCode() == 40 && (d = AbstractValueControl.this.getValue() - AbstractValueControl.this._upDownArrowDelta) >= AbstractValueControl.this.getMinimum()) {
                    AbstractValueControl.this.setValue(d);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AbstractValueControl.this._textField) {
                double d = AbstractValueControl.this.getTextFieldValue();
                if (d < AbstractValueControl.this.getMinimum()) {
                    d = AbstractValueControl.this.getMinimum();
                    Toolkit.getDefaultToolkit().beep();
                } else if (d > AbstractValueControl.this.getMaximum()) {
                    d = AbstractValueControl.this.getMaximum();
                    Toolkit.getDefaultToolkit().beep();
                }
                AbstractValueControl.this.setValue(d);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == AbstractValueControl.this._textField) {
                AbstractValueControl.this._textField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == AbstractValueControl.this._textField) {
                try {
                    AbstractValueControl.this._textField.commitEdit();
                    double d = AbstractValueControl.this.getTextFieldValue();
                    AbstractValueControl.this.setValue(d);
                }
                catch (ParseException parseException) {
                    Toolkit.getDefaultToolkit().beep();
                    AbstractValueControl.this.updateView();
                }
            }
        }
    }
}

