/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.jar.JarFile;

public class FileUtils {
    private FileUtils() {
    }

    public static String getBasename(File file) {
        String string = file.getName();
        String string2 = null;
        int n = string.indexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    public static boolean hasSuffix(File file, String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        return file.getName().toLowerCase().endsWith(string);
    }

    public static File getCodeSource() {
        URL uRL = FileUtils.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            try {
                return new File(URLDecoder.decode(uRL.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                unsupportedEncodingException2.printStackTrace();
                return new File(uRL.getPath());
            }
        }
    }

    public static boolean isJarCodeSource() {
        try {
            return FileUtils.isJar(FileUtils.getCodeSource());
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean isJar(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            jarFile.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

