/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.view.BSAbstractWaveFunctionEquation;
import java.awt.geom.AffineTransform;
import java.util.Observable;

public class BSHilitedEquation
extends BSAbstractWaveFunctionEquation {
    private AffineTransform _xform = new AffineTransform();
    private String _superpositionString = BSResources.getString("label.equation.superposition");

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this.setHTMLColor(bSColorScheme.getEigenstateHiliteColor());
    }

    protected void updateDisplay() {
        if (this.getModel() != null) {
            int n = this.getEigenstateSubscript();
            String string = null;
            if (n == -1) {
                string = "";
            } else if (n == Integer.MIN_VALUE) {
                string = this._superpositionString;
            } else if (this.getMode() == BSBottomPlotMode.WAVE_FUNCTION) {
                string = "<html>\u03c8<sub>" + n + "</sub>(x)</html>";
            } else if (this.getMode() == BSBottomPlotMode.PROBABILITY_DENSITY || this.getMode() == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY) {
                string = "<html>|\u03c8<sub>" + n + "</sub>(x)|<sup>2</sup></html>";
            } else {
                throw new UnsupportedOperationException("unsupported mode: " + this.getMode());
            }
            this.setHTML(string);
            this._xform.setToIdentity();
            this._xform.translate(this.getLocation().getX(), this.getLocation().getY());
            this._xform.translate(-this.getFullBounds().getWidth(), 0.0);
            this.setTransform(this._xform);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.getModel() && object == "hilitedEnergy") {
            this.updateDisplay();
        }
    }

    private int getEigenstateSubscript() {
        BSModel bSModel = this.getModel();
        int n = bSModel.getHilitedEigenstateIndex();
        int n2 = -1;
        if (n != -1) {
            BSEigenstate bSEigenstate = bSModel.getEigenstate(n);
            n2 = bSEigenstate.getSubscript();
        }
        return n2;
    }
}

