/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSWaveFunctionCache;
import edu.colorado.phet.boundstates.view.BSBottomPlot;
import java.awt.geom.Point2D;
import org.jfree.data.xy.XYSeries;

abstract class BSAbstractBottomPlotter
implements BSBottomPlot.IPlotter {
    private BSBottomPlot _plot;
    private BSWaveFunctionCache _cache;
    private XYSeries _hiliteSeries;

    public BSAbstractBottomPlotter(BSBottomPlot bSBottomPlot) {
        this._plot = bSBottomPlot;
        this._cache = new BSWaveFunctionCache();
        this._hiliteSeries = bSBottomPlot.getHiliteSeries();
    }

    public void notifyModelChanged() {
        this.updateCache();
        this.refreshAllSeries();
    }

    public void notifyHiliteChanged() {
        this.updateHiliteSeries();
    }

    protected BSWaveFunctionCache getCache() {
        return this._cache;
    }

    private void updateCache() {
        double d = this._plot.getDomainAxis().getLowerBound();
        double d2 = this._plot.getDomainAxis().getUpperBound();
        this._cache.update(this._plot.getModel(), d, d2);
    }

    protected void updateHiliteSeries() {
        int n;
        this._hiliteSeries.setNotify(false);
        this._hiliteSeries.clear();
        BSModel bSModel = this._plot.getModel();
        if (bSModel != null && (n = bSModel.getHilitedEigenstateIndex()) != -1) {
            BSEigenstate[] bSEigenstateArray = bSModel.getEigenstates();
            BSAbstractPotential bSAbstractPotential = bSModel.getPotential();
            double d = this._plot.getDomainAxis().getLowerBound();
            double d2 = this._plot.getDomainAxis().getUpperBound();
            Point2D[] point2DArray = bSAbstractPotential.getWaveFunctionPoints(bSEigenstateArray[n], d, d2);
            for (int i = 0; i < point2DArray.length; ++i) {
                double d3;
                double d4;
                if (this._plot.isProbabilityDensitySeriesVisible()) {
                    d4 = point2DArray[i].getX();
                    d3 = Math.pow(point2DArray[i].getY(), 2.0);
                    this._hiliteSeries.add(d4, d3);
                    continue;
                }
                if (this._plot.isRealSeriesVisible() || this._plot.isImaginarySeriesVisible()) {
                    d4 = point2DArray[i].getX();
                    d3 = point2DArray[i].getY();
                    this._hiliteSeries.add(d4, d3);
                    continue;
                }
                if (!this._plot.isMagnitudeSeriesVisible() && !this._plot.isPhaseSeriesVisible()) continue;
                d4 = point2DArray[i].getX();
                d3 = Math.abs(point2DArray[i].getY());
                this._hiliteSeries.add(d4, d3);
            }
        }
        this._hiliteSeries.setNotify(true);
    }
}

