/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.persistence;

import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAsymmetricPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb3DPotential;
import edu.colorado.phet.boundstates.model.BSHarmonicOscillatorPotential;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.persistence.BSAsymmetricConfig;
import edu.colorado.phet.boundstates.persistence.BSCoulomb1DConfig;
import edu.colorado.phet.boundstates.persistence.BSCoulomb3DConfig;
import edu.colorado.phet.boundstates.persistence.BSHarmonicOscillatorConfig;
import edu.colorado.phet.boundstates.persistence.BSParticleConfig;
import edu.colorado.phet.boundstates.persistence.BSSquareConfig;
import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;

public class BSModuleConfig
implements IProguardKeepClass {
    private boolean _clockRunning;
    private int _clockIndex;
    private BSParticleConfig _particleConfig;
    private BSAsymmetricConfig _asymmetricConfig;
    private BSCoulomb1DConfig _coulomb1DConfig;
    private BSCoulomb3DConfig _coulomb3DConfig;
    private BSHarmonicOscillatorConfig _harmonicOscillatorConfig;
    private BSSquareConfig _squareConfig;
    private String _selectedWellTypeName;
    private int _numberOfWells;
    private double[] _superpositionCoefficients;
    private String _bottomPlotModeName;
    private boolean _magnifyingGlassSelected;
    private boolean _realSelected;
    private boolean _imaginarySelected;
    private boolean _magnitudeSelected;
    private boolean _phaseSelected;
    private double _fieldConstant;

    public void setNumberOfWells(int n) {
        this._numberOfWells = n;
    }

    public int getNumberOfWells() {
        return this._numberOfWells;
    }

    public void setClockRunning(boolean bl) {
        this._clockRunning = bl;
    }

    public boolean isClockRunning() {
        return this._clockRunning;
    }

    public void setClockIndex(int n) {
        this._clockIndex = n;
    }

    public int getClockIndex() {
        return this._clockIndex;
    }

    public String getBottomPlotModeName() {
        return this._bottomPlotModeName;
    }

    public void setBottomPlotModeName(String string) {
        this._bottomPlotModeName = string;
    }

    public boolean isRealSelected() {
        return this._realSelected;
    }

    public void setRealSelected(boolean bl) {
        this._realSelected = bl;
    }

    public boolean isImaginarySelected() {
        return this._imaginarySelected;
    }

    public void setImaginarySelected(boolean bl) {
        this._imaginarySelected = bl;
    }

    public boolean isMagnitudeSelected() {
        return this._magnitudeSelected;
    }

    public void setMagnitudeSelected(boolean bl) {
        this._magnitudeSelected = bl;
    }

    public boolean isPhaseSelected() {
        return this._phaseSelected;
    }

    public void setPhaseSelected(boolean bl) {
        this._phaseSelected = bl;
    }

    public boolean isMagnifyingGlassSelected() {
        return this._magnifyingGlassSelected;
    }

    public void setMagnifyingGlassSelected(boolean bl) {
        this._magnifyingGlassSelected = bl;
    }

    public BSParticleConfig getParticleConfig() {
        return this._particleConfig;
    }

    public void setParticleConfig(BSParticleConfig bSParticleConfig) {
        this._particleConfig = bSParticleConfig;
    }

    public BSAsymmetricConfig getAsymmetricConfig() {
        return this._asymmetricConfig;
    }

    public void setAsymmetricConfig(BSAsymmetricConfig bSAsymmetricConfig) {
        this._asymmetricConfig = bSAsymmetricConfig;
    }

    public BSCoulomb1DConfig getCoulomb1DConfig() {
        return this._coulomb1DConfig;
    }

    public void setCoulomb1DConfig(BSCoulomb1DConfig bSCoulomb1DConfig) {
        this._coulomb1DConfig = bSCoulomb1DConfig;
    }

    public BSCoulomb3DConfig getCoulomb3DConfig() {
        return this._coulomb3DConfig;
    }

    public void setCoulomb3DConfig(BSCoulomb3DConfig bSCoulomb3DConfig) {
        this._coulomb3DConfig = bSCoulomb3DConfig;
    }

    public BSHarmonicOscillatorConfig getHarmonicOscillatorConfig() {
        return this._harmonicOscillatorConfig;
    }

    public void setHarmonicOscillatorConfig(BSHarmonicOscillatorConfig bSHarmonicOscillatorConfig) {
        this._harmonicOscillatorConfig = bSHarmonicOscillatorConfig;
    }

    public String getSelectedWellTypeName() {
        return this._selectedWellTypeName;
    }

    public void setSelectedWellTypeName(String string) {
        this._selectedWellTypeName = string;
    }

    public BSSquareConfig getSquareConfig() {
        return this._squareConfig;
    }

    public void setSquareConfig(BSSquareConfig bSSquareConfig) {
        this._squareConfig = bSSquareConfig;
    }

    public double[] getSuperpositionCoefficients() {
        return this._superpositionCoefficients;
    }

    public void setSuperpositionCoefficients(double[] dArray) {
        this._superpositionCoefficients = dArray;
    }

    public double getFieldConstant() {
        return this._fieldConstant;
    }

    public void setFieldConstant(double d) {
        this._fieldConstant = d;
    }

    public BSBottomPlotMode loadBottomPlotMode() {
        return BSBottomPlotMode.getByName(this._bottomPlotModeName);
    }

    public void saveBottomPlotMode(BSBottomPlotMode bSBottomPlotMode) {
        this.setBottomPlotModeName(bSBottomPlotMode.getName());
    }

    public BSWellType loadSelectedWellType() {
        return BSWellType.getByName(this._selectedWellTypeName);
    }

    public void saveSelectedWellType(BSWellType bSWellType) {
        this.setSelectedWellTypeName(bSWellType.getName());
    }

    public BSParticle loadParticle() {
        return this._particleConfig.toParticle();
    }

    public void saveParticle(BSParticle bSParticle) {
        this.setParticleConfig(new BSParticleConfig(bSParticle));
    }

    public BSAsymmetricPotential loadAsymmetricPotential(BSParticle bSParticle) {
        BSAsymmetricPotential bSAsymmetricPotential = null;
        if (this._asymmetricConfig != null) {
            bSAsymmetricPotential = this._asymmetricConfig.toPotential(bSParticle);
        }
        return bSAsymmetricPotential;
    }

    public void saveAsymmetricPotential(BSAsymmetricPotential bSAsymmetricPotential) {
        if (bSAsymmetricPotential != null) {
            this.setAsymmetricConfig(new BSAsymmetricConfig(bSAsymmetricPotential));
        }
    }

    public BSCoulomb1DPotential loadCoulomb1DPotential(BSParticle bSParticle) {
        BSCoulomb1DPotential bSCoulomb1DPotential = null;
        if (this._coulomb1DConfig != null) {
            bSCoulomb1DPotential = this._coulomb1DConfig.toPotential(bSParticle);
        }
        return bSCoulomb1DPotential;
    }

    public void saveCoulomb1DPotential(BSCoulomb1DPotential bSCoulomb1DPotential) {
        if (bSCoulomb1DPotential != null) {
            this.setCoulomb1DConfig(new BSCoulomb1DConfig(bSCoulomb1DPotential));
        }
    }

    public BSCoulomb3DPotential loadCoulomb3DPotential(BSParticle bSParticle) {
        BSCoulomb3DPotential bSCoulomb3DPotential = null;
        if (this._coulomb3DConfig != null) {
            bSCoulomb3DPotential = this._coulomb3DConfig.toPotential(bSParticle);
        }
        return bSCoulomb3DPotential;
    }

    public void saveCoulomb3DPotential(BSCoulomb3DPotential bSCoulomb3DPotential) {
        if (bSCoulomb3DPotential != null) {
            this.setCoulomb3DConfig(new BSCoulomb3DConfig(bSCoulomb3DPotential));
        }
    }

    public BSHarmonicOscillatorPotential loadHarmonicOscillatorPotential(BSParticle bSParticle) {
        BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential = null;
        if (this._harmonicOscillatorConfig != null) {
            bSHarmonicOscillatorPotential = this._harmonicOscillatorConfig.toPotential(bSParticle);
        }
        return bSHarmonicOscillatorPotential;
    }

    public void saveHarmonicOscillatorPotential(BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential) {
        if (bSHarmonicOscillatorPotential != null) {
            this.setHarmonicOscillatorConfig(new BSHarmonicOscillatorConfig(bSHarmonicOscillatorPotential));
        }
    }

    public BSSquarePotential loadSquarePotential(BSParticle bSParticle) {
        BSSquarePotential bSSquarePotential = null;
        if (this._squareConfig != null) {
            bSSquarePotential = this._squareConfig.toPotential(bSParticle);
        }
        return bSSquarePotential;
    }

    public void saveSquarePotential(BSSquarePotential bSSquarePotential) {
        if (bSSquarePotential != null) {
            this.setSquareConfig(new BSSquareConfig(bSSquarePotential));
        }
    }
}

