/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.module;

import edu.colorado.phet.boundstates.control.ZoomControl;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.util.AxisSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.text.DecimalFormat;
import org.jfree.data.Range;

public class BSManyWellsSpec
extends BSAbstractModuleSpec {
    private static final BSWellType[] WELL_TYPES = new BSWellType[]{BSWellType.SQUARE, BSWellType.COULOMB_1D};
    private static final BSWellType DEFAULT_WELL_TYPE = BSWellType.SQUARE;
    private static final DoubleRange MASS_MULTIPLIER_RANGE = new DoubleRange(0.5, 1.1, 1.0, 2);
    private static final IntegerRange NUMBER_OF_WELLS_RANGE = new IntegerRange(1, 10, 5);
    private static final DoubleRange FIELD_CONSTANT_RANGE = new DoubleRange(-1.0, 1.0, 0.0, 1);
    private static final Range COULOMB_1D_ENERGY_RANGE1 = new Range(-20.5, 0.5);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT1 = new DecimalFormat("#0");
    private static final Range COULOMB_1D_ENERGY_RANGE2 = new Range(-30.5, 0.5);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT2 = new DecimalFormat("#0");
    private static final Range COULOMB_1D_ENERGY_RANGE3 = new Range(-51.0, 1.0);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT3 = new DecimalFormat("#0");
    private static final Range COULOMB_1D_ENERGY_RANGE4 = new Range(-101.0, 1.0);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT4 = new DecimalFormat("##0");
    private static final Range COULOMB_1D_ENERGY_RANGE5 = new Range(-255.0, 5.0);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT5 = new DecimalFormat("##0");
    private static final DoubleRange COULOMB_1D_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange COULOMB_1D_SPACING_RANGE = new DoubleRange(0.05, 0.7, 0.7, 2);
    private static final Range SQUARE_ENERGY_RANGE1 = new Range(-0.5, 20.5);
    private static final DecimalFormat SQUARE_ENERGY_TICK_FORMAT1 = new DecimalFormat("0");
    private static final Range SQUARE_ENERGY_RANGE2 = new Range(-10.5, 30.5);
    private static final DecimalFormat SQUARE_ENERGY_TICK_FORMAT2 = new DecimalFormat("0");
    private static final DoubleRange SQUARE_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange SQUARE_WIDTH_RANGE = new DoubleRange(0.1, 0.5, 0.5, 2);
    private static final DoubleRange SQUARE_HEIGHT_RANGE = new DoubleRange(0.0, 20.0, 10.0, 1);
    private static final DoubleRange SQUARE_SEPARATION_RANGE = new DoubleRange(0.05, 0.2, 0.1, 2);

    public BSManyWellsSpec() {
        this.setId("manyWellsModule");
        this.setWellTypes(WELL_TYPES);
        this.setDefaultWellType(DEFAULT_WELL_TYPE);
        this.setNumberOfWellsSupported(true);
        this.setOffsetControlSupported(false);
        this.setSuperpositionControlsSupported(false);
        this.setParticleControlsSupported(false);
        this.setMagnifyingGlassSupported(true);
        this.setMagnifyingGlassSelected(true);
        this.setAverageProbabilityDensityIsSupported(true);
        this.setFieldConstantSupported(true);
        this.setMassMultiplierRange(MASS_MULTIPLIER_RANGE);
        this.setNumberOfWellsRange(NUMBER_OF_WELLS_RANGE);
        this.setFieldConstantRange(FIELD_CONSTANT_RANGE);
        this.setMagnification(10.0);
        AxisSpec axisSpec = new AxisSpec(COULOMB_1D_ENERGY_RANGE1, 5.0, COULOMB_1D_ENERGY_TICK_FORMAT1);
        AxisSpec axisSpec2 = new AxisSpec(COULOMB_1D_ENERGY_RANGE2, 5.0, COULOMB_1D_ENERGY_TICK_FORMAT2);
        AxisSpec[] axisSpecArray = new AxisSpec(COULOMB_1D_ENERGY_RANGE3, 10.0, COULOMB_1D_ENERGY_TICK_FORMAT3);
        Object object = new AxisSpec(COULOMB_1D_ENERGY_RANGE4, 20.0, COULOMB_1D_ENERGY_TICK_FORMAT4);
        Object object2 = new AxisSpec(COULOMB_1D_ENERGY_RANGE5, 50.0, COULOMB_1D_ENERGY_TICK_FORMAT5);
        AxisSpec[] axisSpecArray2 = new AxisSpec[]{axisSpec, axisSpec2, axisSpecArray, object, object2};
        ZoomControl.ZoomSpec zoomSpec = new ZoomControl.ZoomSpec(axisSpecArray2);
        BSPotentialSpec.Coulomb1D coulomb1D = new BSPotentialSpec.Coulomb1D(zoomSpec, COULOMB_1D_OFFSET_RANGE, COULOMB_1D_SPACING_RANGE);
        this.setCoulomb1DSpec(coulomb1D);
        axisSpec = new AxisSpec(SQUARE_ENERGY_RANGE1, 5.0, SQUARE_ENERGY_TICK_FORMAT1);
        axisSpec2 = new AxisSpec(SQUARE_ENERGY_RANGE2, 10.0, SQUARE_ENERGY_TICK_FORMAT2);
        axisSpecArray = new AxisSpec[]{axisSpec, axisSpec2};
        object = new ZoomControl.ZoomSpec(axisSpecArray);
        object2 = new BSPotentialSpec.Square((ZoomControl.ZoomSpec)object, SQUARE_OFFSET_RANGE, SQUARE_WIDTH_RANGE, SQUARE_HEIGHT_RANGE, SQUARE_SEPARATION_RANGE);
        this.setSquareSpec((BSPotentialSpec)object2);
    }
}

