/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.model.BSAbstractCoulombSolver;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSParticle;

public class BSCoulomb3DSolver
extends BSAbstractCoulombSolver {
    private static final double SQRT_PI = Math.sqrt(Math.PI);

    public BSCoulomb3DSolver(BSAbstractPotential bSAbstractPotential, BSParticle bSParticle) {
        super(bSAbstractPotential, bSParticle);
    }

    public static double getScalingCoefficient(int n, double d) {
        if (n < 1) {
            throw new IndexOutOfBoundsException("Coulomb eigenstate subscripts start at 1: " + n);
        }
        double d2 = BSCoulomb3DSolver.get_a(d);
        return SQRT_PI * Math.pow((double)n * d2, 1.5);
    }

    protected double psiScaled(int n, double d) {
        assert (n >= 1);
        return BSCoulomb3DSolver.getScalingCoefficient(n, this.getMass()) * this.psi(n, d);
    }
}

