/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;

public class BSSquareSeparationHandle
extends BSPotentialHandle {
    public BSSquareSeparationHandle(BSSquarePotential bSSquarePotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode, 0);
        int n = bSPotentialSpec.getSeparationRange().getSignificantDecimalPlaces();
        String string = BSSquareSeparationHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.separation"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        double d;
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        if (bSSquarePotential.getCenter() != 0.0) {
            throw new UnsupportedOperationException("this implementation only supports potentials centered at 0");
        }
        double d2 = bSPotentialSpec.getSeparationRange().getMin();
        double d3 = bSPotentialSpec.getSeparationRange().getMax();
        double d4 = 0.0;
        double d5 = 0.0;
        int n = bSSquarePotential.getNumberOfWells();
        if (n % 2 == 0) {
            d4 = d2 / 2.0;
            d5 = d3 / 2.0;
        } else {
            d = bSSquarePotential.getWidth();
            d4 = d / 2.0 + d2;
            d5 = d / 2.0 + d3;
        }
        d = bSCombinedChartNode.positionToNode(d4);
        double d6 = bSCombinedChartNode.positionToNode(d5);
        ValueAxis valueAxis = bSCombinedChartNode.getEnergyPlot().getRangeAxis();
        double d7 = valueAxis.getLowerBound();
        double d8 = valueAxis.getUpperBound();
        double d9 = bSCombinedChartNode.energyToNode(d8);
        double d10 = bSCombinedChartNode.energyToNode(d7);
        double d11 = d6 - d;
        double d12 = d10 - d9;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d, d9, d11, d12);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSSquarePotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d = point2D2.getX();
        int n = bSSquarePotential.getNumberOfWells();
        double d2 = 0.0;
        if (n % 2 == 0) {
            d2 = 2.0 * d;
        } else {
            double d3 = bSSquarePotential.getWidth();
            d2 = d - d3 / 2.0;
        }
        int n2 = bSPotentialSpec.getSeparationRange().getSignificantDecimalPlaces();
        d2 = BSSquareSeparationHandle.round(d2, n2);
        bSSquarePotential.setSeparation(d2);
        this.setValueDisplay(d2);
        bSSquarePotential.addObserver(this);
    }

    protected void updateView() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        this.removePropertyChangeListener(this);
        int n = bSSquarePotential.getNumberOfWells();
        double d = bSSquarePotential.getSeparation();
        double d2 = bSSquarePotential.getOffset();
        double d3 = bSSquarePotential.getHeight();
        double d4 = bSSquarePotential.getWidth();
        double d5 = d2 + d3 + 1.0;
        double d6 = 0.0;
        d6 = n % 2 == 0 ? d / 2.0 : d4 / 2.0 + d;
        Point2D.Double double_ = new Point2D.Double(d6, d5);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d);
        this.addPropertyChangeListener(this);
    }
}

