/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.draghandles.BSAbstractHandle;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;

public abstract class BSPotentialHandle
extends BSAbstractHandle
implements Observer {
    private BSAbstractPotential _potential;
    private BSPotentialSpec _potentialSpec;
    private BSCombinedChartNode _chartNode;

    public BSPotentialHandle(BSAbstractPotential bSAbstractPotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode, int n) {
        super(n);
        this._potentialSpec = bSPotentialSpec;
        this._chartNode = bSCombinedChartNode;
        this.setPotential(bSAbstractPotential);
        ValueAxis valueAxis = bSCombinedChartNode.getEnergyPlot().getRangeAxis();
        valueAxis.addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent axisChangeEvent) {
                BSPotentialHandle.this.updateDragBounds();
            }
        });
    }

    protected void setPotential(BSAbstractPotential bSAbstractPotential) {
        if (this._potential != null) {
            this._potential.deleteObserver(this);
        }
        this._potential = bSAbstractPotential;
        this._potential.addObserver(this);
        this.updateView();
    }

    protected BSAbstractPotential getPotential() {
        return this._potential;
    }

    protected BSPotentialSpec getPotentialSpec() {
        return this._potentialSpec;
    }

    protected BSCombinedChartNode getChartNode() {
        return this._chartNode;
    }

    protected Point2D modelToView(Point2D point2D) {
        Point2D point2D2 = this._chartNode.energyToNode(point2D);
        Point2D point2D3 = this._chartNode.localToGlobal(point2D2);
        return point2D3;
    }

    protected Point2D viewToModel(Point2D point2D) {
        Point2D point2D2 = this._chartNode.globalToLocal(point2D);
        Point2D point2D3 = this._chartNode.nodeToEnergy(point2D2);
        return point2D3;
    }

    public void update(Observable observable, Object object) {
        assert (observable == this._potential);
        this.updateDragBounds();
    }

    public static double round(double d, double d2) {
        double d3 = Math.pow(10.0, d2);
        double d4 = 0.49 / d3;
        if (d < 0.0) {
            d4 *= -1.0;
        }
        int n = (int)((d + d4) * d3);
        return (double)n / d3;
    }
}

