/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.controls.DoubleSpinner;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSSuperpositionStateDialog
extends PaintImmediateDialog
implements Observer {
    private static final Dimension SPINNER_SIZE = new Dimension(65, 25);
    private BSModel _model;
    private BSSuperpositionCoefficients _localCoefficients;
    private JPanel _dynamicPanel;
    private ArrayList _spinners;
    private JButton _clearButton;
    private JButton _normalizeButton;
    private JButton _applyButton;
    private JButton _closeButton;
    private EventListener _eventListener;
    private boolean _changed;
    private Color _selectionColor;
    private Color _normalColor;

    public BSSuperpositionStateDialog(Frame frame, BSModel bSModel, BSColorScheme bSColorScheme) {
        super(frame);
        this.setModal(false);
        this.setResizable(false);
        this.setTitle(BSResources.getString("BSSuperpositionStateDialog.title"));
        this._eventListener = new EventListener();
        this.addWindowListener(this._eventListener);
        this._model = bSModel;
        this._localCoefficients = new BSSuperpositionCoefficients(this._model.getSuperpositionCoefficients());
        this._changed = false;
        this._selectionColor = bSColorScheme.getEigenstateSelectionColor();
        this._normalColor = Color.WHITE;
        this.createUI(frame);
        this._model.getSuperpositionCoefficients().addObserver(this);
    }

    public void cleanup() {
        this._model.getSuperpositionCoefficients().deleteObserver(this);
    }

    private void createUI(Frame frame) {
        this._dynamicPanel = new JPanel();
        this._dynamicPanel.add(this.createInputPanel());
        JPanel jPanel = this.createActionsPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel3.add((Component)this._dynamicPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
    }

    private JPanel createInputPanel() {
        int n;
        int n2;
        Serializable serializable;
        JLabel jLabel = new JLabel(BSResources.getString("label.superposition.instructions"));
        int n3 = this._localCoefficients.getNumberOfCoefficients();
        BSEigenstate[] bSEigenstateArray = this._model.getEigenstates();
        assert (bSEigenstateArray.length == n3);
        int n4 = this._model.getPotential().getGroundStateSubscript();
        String string = BSSuperpositionStateDialog.createSuperpositionEquation(n4);
        JLabel jLabel2 = new JLabel(string);
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        this._spinners = new ArrayList();
        for (int i = 0; i < n3; ++i) {
            int n5 = bSEigenstateArray[i].getSubscript();
            String string2 = "<html>" + BSResources.getString("label.superpositionCoefficient") + "<sub>" + n5 + "</sub>:</html>";
            arrayList.add(new JLabel(string2));
            double d = this._localCoefficients.getCoefficient(i);
            serializable = new DoubleSpinner(d, 0.0, 1.0, 0.01, "0.00", SPINNER_SIZE);
            ((JSpinner)serializable).addChangeListener(this._eventListener);
            this._spinners.add(serializable);
        }
        this.updateSpinnersColor();
        JPanel[] jPanelArray = new JPanel[4];
        Object object = new EasyGridBagLayout[4];
        for (n2 = 0; n2 < 4; ++n2) {
            JPanel jPanel = new JPanel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.setAnchor(17);
            jPanelArray[n2] = jPanel;
            object[n2] = easyGridBagLayout;
        }
        n2 = 0;
        int n6 = this._spinners.size() / 4;
        if (this._spinners.size() % 4 != 0) {
            ++n6;
        }
        for (n = 0; n < this._spinners.size(); ++n) {
            serializable = object[n / n6];
            JLabel jLabel3 = (JLabel)arrayList.get(n);
            DoubleSpinner doubleSpinner = (DoubleSpinner)this._spinners.get(n);
            ((EasyGridBagLayout)serializable).addAnchoredComponent(jLabel3, n2, 0, 13);
            ((EasyGridBagLayout)serializable).addAnchoredComponent(doubleSpinner, n2, 1, 17);
            ++n2;
        }
        object = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(11);
        n6 = 0;
        easyGridBagLayout.addAnchoredComponent(jLabel, n6, 0, 100, 1, 17);
        easyGridBagLayout.addAnchoredComponent(jLabel2, ++n6, 0, 100, 1, 17);
        ++n6;
        for (n = 0; n < jPanelArray.length; ++n) {
            easyGridBagLayout.addComponent(jPanelArray[n], n6, n);
        }
        ++n6;
        return object;
    }

    private JPanel createActionsPanel() {
        this._clearButton = new JButton(BSResources.getString("button.clear"));
        this._clearButton.addActionListener(this._eventListener);
        this._normalizeButton = new JButton(BSResources.getString("button.normalize"));
        this._normalizeButton.addActionListener(this._eventListener);
        this._applyButton = new JButton(BSResources.getString("button.apply"));
        this._applyButton.addActionListener(this._eventListener);
        this._closeButton = new JButton(BSResources.getString("button.close"));
        this._closeButton.addActionListener(this._eventListener);
        JPanel jPanel = new JPanel(new GridLayout(1, 4, 5, 0));
        jPanel.add(this._clearButton);
        jPanel.add(this._normalizeButton);
        jPanel.add(this._applyButton);
        jPanel.add(this._closeButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        this.updateButtons();
        return jPanel2;
    }

    private static String createSuperpositionEquation(int n) {
        int n2 = n;
        String string = "<html>\u03c8(x) = c<sub>" + n2 + "</sub>" + '\u03c8' + "<sub>" + n2++ + "</sub>(x) + " + "c<sub>" + n2 + "</sub>" + '\u03c8' + "<sub>" + n2++ + "</sub>(x) + ... + " + "c<sub>n</sub>" + '\u03c8' + "<sub>n</sub>(x)";
        return string;
    }

    private static String createNormalizationEquation(int n) {
        int n2 = n;
        String string = "c<sub>" + n2++ + "</sub><sup>2</sup> + " + "c<sub>" + n2++ + "</sub><sup>2</sup> + ... + " + "c<sub>n</sub><sup>2</sup> = 1";
        return string;
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this._selectionColor = bSColorScheme.getEigenstateSelectionColor();
        this.updateSpinnersColor();
    }

    public void update(Observable observable, Object object) {
        if (observable == this._model.getSuperpositionCoefficients()) {
            this._localCoefficients = new BSSuperpositionCoefficients(this._model.getSuperpositionCoefficients());
            int n = this._localCoefficients.getNumberOfCoefficients();
            if (this._spinners.size() == n) {
                this.updateSpinners();
            } else {
                this._dynamicPanel.removeAll();
                this._dynamicPanel.add(this.createInputPanel());
                this.pack();
            }
            this._changed = false;
        }
    }

    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    private void apply() {
        BSSuperpositionCoefficients bSSuperpositionCoefficients;
        if (this._localCoefficients.isNormalized(0.01)) {
            bSSuperpositionCoefficients = this._model.getSuperpositionCoefficients();
            bSSuperpositionCoefficients.setNotifyEnabled(false);
            int n = this._localCoefficients.getNumberOfCoefficients();
            for (int i = 0; i < n; ++i) {
                bSSuperpositionCoefficients.setCoefficient(i, this._localCoefficients.getCoefficient(i));
            }
        } else {
            throw new IllegalStateException("attempt to apply unnormalized");
        }
        this._changed = false;
        bSSuperpositionCoefficients.setNotifyEnabled(true);
    }

    private void updateButtons() {
        this._applyButton.setEnabled(this._changed && !this.isSumZero());
        this._normalizeButton.setEnabled(!this.isSumZero());
    }

    private void updateSpinners() {
        int n = this._localCoefficients.getNumberOfCoefficients();
        for (int i = 0; i < n; ++i) {
            DoubleSpinner doubleSpinner = (DoubleSpinner)this._spinners.get(i);
            doubleSpinner.setDoubleValue(this._localCoefficients.getCoefficient(i));
            this.updateSpinnerColor(doubleSpinner);
        }
    }

    private void normalize() {
        this._localCoefficients.normalize();
        this.updateSpinners();
    }

    private boolean isSumZero() {
        return this._localCoefficients.getSum() == 0.0;
    }

    private void handleClearAction() {
        this._localCoefficients.setAllZero();
        this.updateSpinners();
        this.updateButtons();
    }

    private void handleNormalizeAction() {
        this.normalize();
        this.updateButtons();
    }

    private void handleApplyAction() {
        if (this._localCoefficients.isNormalized(0.01)) {
            this.apply();
        } else {
            String string = BSResources.getString("message.confirmNormalizeApply");
            int n = this._model.getPotential().getGroundStateSubscript();
            String string2 = BSSuperpositionStateDialog.createNormalizationEquation(n);
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{string2};
            String string3 = messageFormat.format(objectArray);
            int n2 = PhetOptionPane.showYesNoDialog(this, string3);
            if (n2 == 0) {
                this.normalize();
                this.apply();
            } else if (n2 == 1) {
                // empty if block
            }
        }
        this.updateButtons();
    }

    private void handleCloseAction() {
        if (!this._changed || this.isSumZero()) {
            this.dispose();
        } else {
            int n;
            String string = BSResources.getString("message.confirmApplyClose");
            if (!this._localCoefficients.isNormalized(0.01)) {
                string = BSResources.getString("message.confirmNormalizeApplyClose");
            }
            if ((n = PhetOptionPane.showYesNoCancelDialog(this, string)) == 0) {
                this.normalize();
                this.apply();
                this.dispose();
            } else if (n == 1) {
                this.dispose();
            }
        }
        this.updateButtons();
    }

    private void handleCoefficientChange(DoubleSpinner doubleSpinner) {
        int n = this.getSpinnerIndex(doubleSpinner);
        double d = doubleSpinner.getDoubleValue();
        if (d < 0.0 || d > 1.0) {
            this.warnInvalidInput();
            doubleSpinner.setDoubleValue(this._localCoefficients.getCoefficient(n));
        } else {
            this._localCoefficients.setCoefficient(n, d);
            this._changed = true;
        }
        this.updateSpinnerColor(doubleSpinner);
        this.updateButtons();
    }

    private int getSpinnerIndex(DoubleSpinner doubleSpinner) {
        int n = -1;
        int n2 = this._spinners.size();
        for (int i = 0; i < n2; ++i) {
            if (this._spinners.get(i) != doubleSpinner) continue;
            n = i;
            break;
        }
        assert (n != -1);
        return n;
    }

    private void updateSpinnersColor() {
        for (DoubleSpinner doubleSpinner : this._spinners) {
            this.updateSpinnerColor(doubleSpinner);
        }
    }

    private void updateSpinnerColor(DoubleSpinner doubleSpinner) {
        double d = doubleSpinner.getDoubleValue();
        if (d != 0.0) {
            doubleSpinner.getFormattedTextField().setBackground(this._selectionColor);
        } else {
            doubleSpinner.getFormattedTextField().setBackground(this._normalColor);
        }
    }

    private void warnInvalidInput() {
        Toolkit.getDefaultToolkit().beep();
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    ChangeListener {
        private EventListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            BSSuperpositionStateDialog.this.handleCloseAction();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BSSuperpositionStateDialog.this._clearButton) {
                BSSuperpositionStateDialog.this.handleClearAction();
            } else if (actionEvent.getSource() == BSSuperpositionStateDialog.this._normalizeButton) {
                BSSuperpositionStateDialog.this.handleNormalizeAction();
            } else if (actionEvent.getSource() == BSSuperpositionStateDialog.this._applyButton) {
                BSSuperpositionStateDialog.this.handleApplyAction();
            } else if (actionEvent.getSource() == BSSuperpositionStateDialog.this._closeButton) {
                BSSuperpositionStateDialog.this.handleCloseAction();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!BSSuperpositionStateDialog.this._spinners.contains(changeEvent.getSource())) {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
            BSSuperpositionStateDialog.this.handleCoefficientChange((DoubleSpinner)changeEvent.getSource());
        }
    }
}

