/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.dialog.BSAbstractConfigureDialog;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSCoulomb1DDialog
extends BSAbstractConfigureDialog {
    private LinearValueControl _offsetControl;
    private LinearValueControl _spacingControl;
    private JSeparator _spacingSeparator;
    private JLabel _nothingToConfigureLabel;

    public BSCoulomb1DDialog(Frame frame, BSCoulomb1DPotential bSCoulomb1DPotential, BSAbstractModuleSpec bSAbstractModuleSpec) {
        super(frame, BSResources.getString("BSCoulomb1DDialog.title"), bSCoulomb1DPotential);
        System.out.println("BSCoulomb1DDialog");
        JPanel jPanel = this.createInputPanel(bSAbstractModuleSpec);
        this.createUI(jPanel);
        this.updateControls();
    }

    protected JPanel createInputPanel(BSAbstractModuleSpec bSAbstractModuleSpec) {
        String string;
        int n;
        String string2;
        double d;
        double d2;
        double d3;
        Object object;
        BSPotentialSpec bSPotentialSpec = bSAbstractModuleSpec.getCoulomb1DSpec();
        String string3 = BSResources.getString("units.position");
        String string4 = BSResources.getString("units.energy");
        if (bSAbstractModuleSpec.isOffsetControlSupported()) {
            object = bSPotentialSpec.getOffsetRange();
            d3 = ((DoubleRange)object).getDefault();
            d2 = ((DoubleRange)object).getMin();
            d = ((DoubleRange)object).getMax();
            string2 = "0.0";
            n = 4;
            string = BSResources.getString("label.wellOffset");
            this._offsetControl = new LinearValueControl(d2, d, string, string2, string4);
            this._offsetControl.setValue(d3);
            this._offsetControl.setUpDownArrowDelta(0.1);
            this._offsetControl.setTextFieldColumns(n);
            this._offsetControl.setTextFieldEditable(true);
            this._offsetControl.setNotifyWhileAdjusting(false);
            this._offsetControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BSCoulomb1DDialog.this.handleOffsetChange();
                }
            });
        }
        if (bSAbstractModuleSpec.getNumberOfWellsRange().getMax() > 1) {
            object = bSPotentialSpec.getSpacingRange();
            d3 = ((DoubleRange)object).getDefault();
            d2 = ((DoubleRange)object).getMin();
            d = ((DoubleRange)object).getMax();
            string2 = "0.00";
            n = 4;
            string = BSResources.getString("label.wellSpacing");
            this._spacingControl = new LinearValueControl(d2, d, string, string2, string3);
            this._spacingControl.setValue(d3);
            this._spacingControl.setUpDownArrowDelta(0.01);
            this._spacingControl.setTextFieldColumns(n);
            this._spacingControl.setTextFieldEditable(true);
            this._spacingControl.setNotifyWhileAdjusting(false);
            this._spacingControl.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BSCoulomb1DDialog.this.handleSpacingChange();
                }
            });
        }
        this._nothingToConfigureLabel = new JLabel(BSResources.getString("label.nothingToConfigure"));
        object = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n2 = 0;
        int n3 = 0;
        if (this._offsetControl != null) {
            easyGridBagLayout.addComponent(this._offsetControl, n2++, n3);
        }
        if (this._offsetControl != null && this._spacingControl != null) {
            this._spacingSeparator = new JSeparator();
            easyGridBagLayout.addFilledComponent(this._spacingSeparator, n2++, n3, 2);
        }
        if (this._spacingControl != null) {
            easyGridBagLayout.addComponent(this._spacingControl, n2++, n3);
        }
        if (this._nothingToConfigureLabel != null) {
            easyGridBagLayout.addComponent(this._nothingToConfigureLabel, n2++, n3);
        }
        ++n2;
        return object;
    }

    protected void updateControls() {
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        if (this._offsetControl != null) {
            this._offsetControl.setValue(bSCoulomb1DPotential.getOffset());
        }
        if (this._spacingControl != null) {
            this._spacingControl.setValue(bSCoulomb1DPotential.getSpacing());
            this._spacingControl.setVisible(bSCoulomb1DPotential.getNumberOfWells() > 1);
            if (this._spacingSeparator != null) {
                this._spacingSeparator.setVisible(this._spacingControl.isVisible());
            }
        }
        this._nothingToConfigureLabel.setVisible(this._offsetControl == null && (this._spacingControl == null || !this._spacingControl.isVisible()));
        this.pack();
    }

    private void handleOffsetChange() {
        double d = this._offsetControl.getValue();
        this.setObservePotential(false);
        this.getPotential().setOffset(d);
        this.setObservePotential(true);
        this.adjustClockState(this._offsetControl);
    }

    private void handleSpacingChange() {
        double d = this._spacingControl.getValue();
        this.setObservePotential(false);
        ((BSCoulomb1DPotential)this.getPotential()).setSpacing(d);
        this.setObservePotential(true);
        this.adjustClockState(this._spacingControl);
    }
}

