/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.dialog.BSAbstractConfigureDialog;
import edu.colorado.phet.boundstates.dialog.BSAsymmetricDialog;
import edu.colorado.phet.boundstates.dialog.BSCoulomb1DDialog;
import edu.colorado.phet.boundstates.dialog.BSCoulomb3DDialog;
import edu.colorado.phet.boundstates.dialog.BSHarmonicOscillatorDialog;
import edu.colorado.phet.boundstates.dialog.BSSquareDialog;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSAsymmetricPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb3DPotential;
import edu.colorado.phet.boundstates.model.BSHarmonicOscillatorPotential;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import java.awt.Frame;
import javax.swing.JDialog;

public class BSConfigureDialogFactory {
    public static JDialog createDialog(Frame frame, BSAbstractPotential bSAbstractPotential, BSAbstractModuleSpec bSAbstractModuleSpec) {
        BSAbstractConfigureDialog bSAbstractConfigureDialog = null;
        BSWellType bSWellType = bSAbstractPotential.getWellType();
        if (bSWellType == BSWellType.ASYMMETRIC) {
            bSAbstractConfigureDialog = new BSAsymmetricDialog(frame, (BSAsymmetricPotential)bSAbstractPotential, bSAbstractModuleSpec);
        } else if (bSWellType == BSWellType.COULOMB_1D) {
            bSAbstractConfigureDialog = new BSCoulomb1DDialog(frame, (BSCoulomb1DPotential)bSAbstractPotential, bSAbstractModuleSpec);
        } else if (bSWellType == BSWellType.COULOMB_3D) {
            bSAbstractConfigureDialog = new BSCoulomb3DDialog(frame, (BSCoulomb3DPotential)bSAbstractPotential, bSAbstractModuleSpec);
        } else if (bSWellType == BSWellType.HARMONIC_OSCILLATOR) {
            bSAbstractConfigureDialog = new BSHarmonicOscillatorDialog(frame, (BSHarmonicOscillatorPotential)bSAbstractPotential, bSAbstractModuleSpec);
        } else if (bSWellType == BSWellType.SQUARE) {
            bSAbstractConfigureDialog = new BSSquareDialog(frame, (BSSquarePotential)bSAbstractPotential, bSAbstractModuleSpec);
        } else {
            throw new IllegalArgumentException("unsupported well type: " + bSWellType);
        }
        return bSAbstractConfigureDialog;
    }
}

