/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.color;

import edu.colorado.phet.boundstates.BSAbstractApplication;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSBlackColorScheme;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.color.BSColorSchemeDialog;
import edu.colorado.phet.boundstates.color.BSWhiteColorScheme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class BSColorsMenu
extends JMenu {
    private BSAbstractApplication _app;
    private BSColorScheme _presetColorScheme;
    private BSColorScheme _customColorScheme;
    private JDialog _customDialog;
    private JRadioButtonMenuItem _blackItem;
    private JRadioButtonMenuItem _whiteItem;
    private JRadioButtonMenuItem _customItem;

    public BSColorsMenu(BSAbstractApplication bSAbstractApplication) {
        super(BSResources.getString("menu.colors"));
        this.setMnemonic(BSResources.getString("menu.colors.mnemonic").charAt(0));
        this._app = bSAbstractApplication;
        this._blackItem = new JRadioButtonMenuItem(BSResources.getString("menu.colors.black"));
        this._blackItem.setMnemonic(BSResources.getChar("menu.colors.black.mnemonic", 'B'));
        this._blackItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BSColorsMenu.this.handleBlackSelection();
            }
        });
        this._whiteItem = new JRadioButtonMenuItem(BSResources.getString("menu.colors.white"));
        this._whiteItem.setMnemonic(BSResources.getChar("menu.colors.white.mnemonic", 'W'));
        this._whiteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BSColorsMenu.this.handleWhiteSelection();
            }
        });
        this._customItem = new JRadioButtonMenuItem(BSResources.getString("menu.colors.custom"));
        this._customItem.setMnemonic(BSResources.getChar("menu.colors.custom.mnemonic", 'C'));
        this._customItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BSColorsMenu.this.handleCustomSelection();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._blackItem);
        buttonGroup.add(this._whiteItem);
        buttonGroup.add(this._customItem);
        this.add(this._blackItem);
        this.add(this._whiteItem);
        this.add(this._customItem);
        this.selectBlack();
    }

    public void selectBlack() {
        this._blackItem.setSelected(true);
        this.handleBlackSelection();
    }

    public void selectWhite() {
        this._whiteItem.setSelected(true);
        this.handleWhiteSelection();
    }

    public void setColorScheme(String string, BSColorScheme bSColorScheme) {
        this.closeDialog();
        if (string.equals("black")) {
            this.selectBlack();
        } else if (string.equals("white")) {
            this.selectWhite();
        } else {
            this._customItem.setSelected(true);
            this._customColorScheme = new BSColorScheme(bSColorScheme);
            this._app.setColorScheme(this._customColorScheme);
        }
    }

    public BSColorScheme getColorScheme() {
        if (this._customItem.isSelected()) {
            return this._customColorScheme;
        }
        return this._presetColorScheme;
    }

    public String getColorSchemeName() {
        String string = null;
        if (this._blackItem.isSelected()) {
            string = "black";
        } else if (this._whiteItem.isSelected()) {
            string = "white";
        } else if (this._customItem.isSelected()) {
            string = "custom";
        }
        return string;
    }

    private void handleBlackSelection() {
        this.closeDialog();
        this._presetColorScheme = new BSBlackColorScheme();
        this._app.setColorScheme(this._presetColorScheme);
    }

    private void handleWhiteSelection() {
        this.closeDialog();
        this._presetColorScheme = new BSWhiteColorScheme();
        this._app.setColorScheme(this._presetColorScheme);
    }

    private void handleCustomSelection() {
        this.closeDialog();
        if (this._customColorScheme == null) {
            this._customColorScheme = new BSColorScheme(this._presetColorScheme);
        }
        this._app.setColorScheme(this._customColorScheme);
        this._customDialog = new BSColorSchemeDialog(this._app, this._customColorScheme);
        this._customDialog.show();
    }

    private void closeDialog() {
        if (this._customDialog != null) {
            this._customDialog.dispose();
            this._customDialog = null;
        }
    }
}

