/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.view;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.photoelectric.PhotoelectricConfig;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.controller.BeamControl;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import edu.colorado.phet.photoelectric.model.util.PhotoelectricModelUtil;
import edu.colorado.phet.photoelectric.module.PhotoelectricModule;
import edu.colorado.phet.photoelectric.view.CurrentVsIntensityGraph;
import edu.colorado.phet.photoelectric.view.CurrentVsVoltageGraph;
import edu.colorado.phet.photoelectric.view.EnergyVsFrequencyGraph;
import edu.colorado.phet.photoelectric.view.GraphPanel;
import edu.colorado.phet.photoelectric.view.PhotoelectricGraph;
import edu.colorado.phet.photoelectric.view.util.RotatedTextLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class CompositeGraphPanel
extends JPanel {
    private ControlPanel controlPanel;
    private int rowIdx;
    private ArrayList checkBoxes = new ArrayList();
    private Module module;
    private JButton snapshotBtn;
    private ImageIcon snapshotIcon;
    private ImageIcon zoomInIcon;
    private ImageIcon zoomOutIcon;
    private Dimension btnSize;

    public CompositeGraphPanel(Module module) {
        super(new GridBagLayout());
        this.add(Box.createHorizontalStrut(260), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(0.7, 0.7), 2);
        BufferedImage bufferedImage = PhotoelectricResources.getImage("camera.png");
        bufferedImage = affineTransformOp.filter(bufferedImage, null);
        AffineTransformOp affineTransformOp2 = new AffineTransformOp(AffineTransform.getScaleInstance(0.9, 0.9), 2);
        this.snapshotIcon = new ImageIcon(bufferedImage);
        BufferedImage bufferedImage2 = PhotoelectricResources.getImage("zoomIn.gif");
        bufferedImage2 = affineTransformOp2.filter(bufferedImage2, null);
        this.zoomInIcon = new ImageIcon(bufferedImage2);
        BufferedImage bufferedImage3 = PhotoelectricResources.getImage("zoomOut.gif");
        bufferedImage3 = affineTransformOp2.filter(bufferedImage3, null);
        this.zoomOutIcon = new ImageIcon(bufferedImage3);
        this.btnSize = new Dimension(this.snapshotIcon.getIconWidth() + 8, this.snapshotIcon.getIconHeight() + 8);
        PhotoelectricModel photoelectricModel = (PhotoelectricModel)module.getModel();
        this.controlPanel = module.getControlPanel();
        this.module = module;
        Insets insets = new Insets(5, 20, 17, 15);
        this.snapshotBtn = new JButton(new SnapshotAction(this.snapshotIcon, this));
        this.snapshotBtn.setPreferredSize(this.btnSize);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.snapshotBtn, gridBagConstraints);
        GraphPanel graphPanel = new GraphPanel(module.getClock());
        graphPanel.setGraph(new CurrentVsVoltageGraph(graphPanel, photoelectricModel), insets);
        this.addGraph(PhotoelectricResources.getString("GraphTitle.CurrentVsVoltage"), graphPanel, PhotoelectricResources.getString("Voltage"), PhotoelectricResources.getString("Current"));
        GraphPanel graphPanel2 = new GraphPanel(module.getClock());
        graphPanel2.setGraph(new CurrentVsIntensityGraph(graphPanel2, photoelectricModel), insets);
        this.addGraph(PhotoelectricResources.getString("GraphTitle.CurrentVsIntensity"), graphPanel2, PhotoelectricResources.getString("GraphLabel.Intensity"), PhotoelectricResources.getString("GraphLabel.Current"));
        GraphPanel graphPanel3 = new GraphPanel(module.getClock());
        graphPanel3.setGraph(new EnergyVsFrequencyGraph(graphPanel2, photoelectricModel), insets);
        this.addGraph(PhotoelectricResources.getString("GraphTitle.EnergyVsFrequency"), graphPanel3, PhotoelectricResources.getString("GraphLabel.Frequency"), PhotoelectricResources.getString("GraphLabel.Energy"));
        this.setBorder(new TitledBorder(PhotoelectricResources.getString("Graphs")));
    }

    private void setLogoVisibility(ControlPanel controlPanel) {
        boolean bl = true;
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.checkBoxes.get(i);
            if (!jCheckBox.isSelected()) continue;
            bl = false;
        }
        this.module.getLogoPanel().setVisible(bl);
    }

    private void addGraph(String string, final GraphPanel graphPanel, String string2, String string3) {
        final JCheckBox jCheckBox = new JCheckBox(string);
        this.checkBoxes.add(jCheckBox);
        final RotatedTextLabel rotatedTextLabel = new RotatedTextLabel(string3);
        final JLabel jLabel = new JLabel(string2);
        final JButton jButton = new JButton(new ZoomInAction(this.zoomInIcon, graphPanel.getGraph()));
        jButton.setPreferredSize(this.btnSize);
        final JButton jButton2 = new JButton(new ZoomOutAction(this.zoomOutIcon, graphPanel.getGraph()));
        jButton2.setPreferredSize(this.btnSize);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                graphPanel.setVisible(jCheckBox.isSelected());
                graphPanel.clearGraph();
                rotatedTextLabel.setVisible(jCheckBox.isSelected());
                jLabel.setVisible(jCheckBox.isSelected());
                jButton.setVisible(jCheckBox.isSelected());
                jButton2.setVisible(jCheckBox.isSelected());
                CompositeGraphPanel.this.setLogoVisibility(CompositeGraphPanel.this.controlPanel);
                CompositeGraphPanel.this.setSnapshotButtonVisibility(CompositeGraphPanel.this.checkBoxes);
            }
        });
        graphPanel.setVisible(jCheckBox.isSelected());
        rotatedTextLabel.setVisible(jCheckBox.isSelected());
        jLabel.setVisible(jCheckBox.isSelected());
        jButton.setVisible(jCheckBox.isSelected());
        jButton2.setVisible(jCheckBox.isSelected());
        this.setLogoVisibility(this.controlPanel);
        this.setSnapshotButtonVisibility(this.checkBoxes);
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this.rowIdx, 2, 1, 0.0, 0.0, 18, 0, insets, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, this.rowIdx + 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(1, this.rowIdx + 2, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, this.rowIdx + 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(2, this.rowIdx + 1, 1, 1, 0.0, 0.0, 11, 3, insets, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        this.add((Component)rotatedTextLabel, gridBagConstraints4);
        this.add((Component)graphPanel, gridBagConstraints2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints6);
        gridBagConstraints6.anchor = 11;
        jPanel.add((Component)jButton2, gridBagConstraints6);
        this.add((Component)jPanel, gridBagConstraints5);
        this.add((Component)jLabel, gridBagConstraints3);
        this.rowIdx += 3;
    }

    private void setSnapshotButtonVisibility(ArrayList arrayList) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)arrayList.get(i);
            bl |= jCheckBox.isSelected();
        }
        this.snapshotBtn.setVisible(bl);
    }

    private static class Snapshot
    extends JPanel {
        BufferedImage bi;

        public Snapshot(Component component, Module module) {
            this.bi = (BufferedImage)component.createImage(component.getWidth(), component.getHeight());
            Graphics graphics = this.bi.getGraphics();
            component.paint(graphics);
            this.setSize(this.bi.getWidth(), this.bi.getHeight());
            this.setPreferredSize(this.getSize());
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.bi, 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }

    private class SnapshotAction
    extends AbstractAction {
        private Component component;
        Point nextLocation;
        int subsequentSnapshotOffset;

        public SnapshotAction(Icon icon, Component component) {
            super("", icon);
            this.nextLocation = new Point();
            this.subsequentSnapshotOffset = 30;
            this.component = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDialog jDialog = this.createSnapshotDialog();
            jDialog.setLocation(this.nextLocation);
            this.nextLocation.setLocation(this.nextLocation.getX() + (double)this.subsequentSnapshotOffset, this.nextLocation.getY() + (double)this.subsequentSnapshotOffset);
        }

        private JDialog createSnapshotDialog() {
            String string;
            JDialog jDialog = new JDialog((Frame)PhetUtilities.getPhetFrame(), false);
            jDialog.setResizable(false);
            Snapshot snapshot = new Snapshot(this.component, CompositeGraphPanel.this.module);
            PhotoelectricModel photoelectricModel = (PhotoelectricModel)CompositeGraphPanel.this.module.getModel();
            String string2 = photoelectricModel.getTarget().getMaterial().toString();
            double d = photoelectricModel.getVoltage();
            double d2 = photoelectricModel.getBeam().getWavelength();
            double d3 = 0.0;
            if (((PhotoelectricModule)CompositeGraphPanel.this.module).getBeamControl().getMode() == BeamControl.INTENSITY) {
                string = "Intensity";
                d3 = PhotoelectricModelUtil.photonRateToIntensity(photoelectricModel.getBeam().getPhotonsPerSecond() / PhotoelectricModel.MAX_PHOTONS_PER_SECOND, photoelectricModel.getBeam().getWavelength());
            } else {
                string = "Photon Rate";
                d3 = photoelectricModel.getBeam().getPhotonsPerSecond() / PhotoelectricModel.MAX_PHOTONS_PER_SECOND;
            }
            String string3 = "<html><table border=\"1\" ><tr><td align=\"center\">Material</td><td align=\"center\">Wavelength</td><td align=\"center\">" + string + "</td>" + "<td align=\"center\">" + "Voltage" + "</td>" + "</tr>" + "<tr>" + "<td align=\"center\">" + string2 + "</td>" + "<td align=\"center\">" + PhotoelectricConfig.BEAM_WAVELENGTH_FORMAT.format(d2) + "</td>" + "<td align=\"center\">" + PhotoelectricConfig.BEAM_PERCENTAGE_FORMAT.format(d3) + "</td>" + "<td align=\"center\">" + DischargeLampsConfig.VOLTAGE_FORMAT.format(d) + "</td>" + "</tr>" + "</table></html>";
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new TitledBorder("Experimental Parameters"));
            jPanel.add(new JLabel(string3));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)jPanel, "North");
            jPanel2.add((Component)snapshot, "Center");
            jDialog.setContentPane(jPanel2);
            jDialog.pack();
            jDialog.setVisible(true);
            return jDialog;
        }
    }

    private static class ZoomInAction
    extends AbstractAction {
        private PhotoelectricGraph graph;

        public ZoomInAction(Icon icon, PhotoelectricGraph photoelectricGraph) {
            super("", icon);
            this.graph = photoelectricGraph;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.graph.zoomIn();
        }
    }

    private static class ZoomOutAction
    extends AbstractAction {
        private PhotoelectricGraph graph;

        public ZoomOutAction(Icon icon, PhotoelectricGraph photoelectricGraph) {
            super("", icon);
            this.graph = photoelectricGraph;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.graph.zoomOut();
        }
    }
}

