/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.photoelectric.PhotoelectricResources;
import edu.colorado.phet.photoelectric.model.Ammeter;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.text.DecimalFormat;

public class AmmeterViewGraphic
extends CompositePhetGraphic {
    private Font font = new PhetFont(1, 14);
    private PhetShapeGraphic background1;
    private PhetShapeGraphic background2;
    private PhetTextGraphic currentLabel;
    private PhetTextGraphic currentTF;
    private DecimalFormat format = new DecimalFormat("#0.000");

    public AmmeterViewGraphic(Component component, Ammeter ammeter, final PhotoelectricModel photoelectricModel) {
        this.background1 = new PhetShapeGraphic(component, new Rectangle(120, 20), Color.white, new BasicStroke(1.0f), Color.black);
        this.background2 = new PhetShapeGraphic(component, new Rectangle(130, 30), Color.yellow, new BasicStroke(1.0f), Color.black);
        this.background2.setRegistrationPoint(5, 5);
        this.currentLabel = new PhetTextGraphic(component, this.font, PhotoelectricResources.getString("GraphLabel.Current") + ": ", Color.black);
        this.currentLabel.setLocation(5, 5);
        this.currentTF = new PhetTextGraphic(component, this.font, "0.000", Color.black);
        this.currentTF.setLocation(75, 5);
        this.addGraphic(this.background2);
        this.addGraphic(this.background1);
        this.addGraphic(this.currentLabel);
        this.addGraphic(this.currentTF);
        photoelectricModel.addChangeListener(new PhotoelectricModel.ChangeListenerAdapter(){

            public void currentChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                double d = photoelectricModel.getCurrent();
                if (d == 0.0) {
                    d = 0.0;
                }
                AmmeterViewGraphic.this.currentTF.setText(AmmeterViewGraphic.this.format.format(d));
                AmmeterViewGraphic.this.setBoundsDirty();
                AmmeterViewGraphic.this.repaint();
            }
        });
    }
}

