/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.model;

import java.util.Random;

public interface InitialElectronSpeedStrategy {
    public double determineNewElectronSpeed(double var1);

    public static class Randomized
    extends Uniform {
        private Random random = new Random();
        private double minSpeed;

        public Randomized(double d, double d2) {
            super(d);
            this.minSpeed = d2;
        }

        public double determineNewElectronSpeed(double d) {
            double d2 = super.determineNewElectronSpeed(d);
            double d3 = d2 * this.random.nextDouble();
            d3 = Math.max(d3, this.minSpeed);
            return d3;
        }
    }

    public static class Uniform
    implements InitialElectronSpeedStrategy {
        private double scaleFactor = 1.0;

        public Uniform(double d) {
            this.scaleFactor = d;
        }

        public double determineNewElectronSpeed(double d) {
            double d2 = Math.sqrt(2.0 * d / 9.109E-31) * this.scaleFactor;
            return d2;
        }
    }
}

