/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class EnergySquiggle
extends PhetImageGraphic {
    private static int numArrowheads = 1;

    public EnergySquiggle(Component component, double d, double d2, int n, int n2, int n3) {
        super(component);
        this.setImage(this.computeSquiggleImage(d, d2, n, n2, n3));
    }

    private BufferedImage computeSquiggleImage(double d, double d2, int n, int n2, int n3) {
        int n4 = n - 1;
        int n5 = n2;
        if (n4 + numArrowheads * n5 <= 0 || n2 <= 0) {
            System.out.println("EnergySquiggle.computeSquiggleImage");
        }
        BufferedImage bufferedImage = new BufferedImage(n4 + numArrowheads * n5, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = VisibleColor.wavelengthToColor(d);
        if (color.getRed() == 0 && color.getGreen() == 0 & color.getBlue() == 0) {
            color = Color.black;
        }
        graphics2D.setColor(color);
        int n6 = n2 / 2;
        int n7 = 0;
        int n8 = n5 * (numArrowheads - 1);
        double d3 = Math.max(d, 190.0);
        double d4 = 15.0 * d3 / 680.0;
        for (int i = 0; i < n4 - n5 * numArrowheads; ++i) {
            int n9 = (int)(Math.sin(d2 + (double)i * Math.PI * 2.0 / d4) * (double)n2 / 2.0 + (double)(n2 / 2));
            for (int j = 0; j < n2; ++j) {
                if (j != n9) continue;
                graphics2D.drawLine(n7 + n8, n6, i + n8, n9);
                n7 = i;
                n6 = n9;
            }
        }
        if (numArrowheads == 2) {
            Arrow arrow = new Arrow(new Point2D.Double(n5, n2 / 2), new Point2D.Double(0.0, n2 / 2), n5, (double)n2 * 1.2, 2.0);
            graphics2D.fill(arrow.getShape());
        }
        Arrow arrow = new Arrow(new Point2D.Double(n4 - n5, n2 / 2), new Point2D.Double(n4, n2 / 2), n5, (double)n2 * 1.2, 2.0);
        graphics2D.fill(arrow.getShape());
        graphics2D.dispose();
        if (n3 == 1) {
            bufferedImage = BufferedImageUtils.getRotatedImage(bufferedImage, 1.5707963267948966);
        }
        return bufferedImage;
    }
}

