/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.quantum.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollisionExpert;
import edu.colorado.phet.common.collision.CollisionUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.Photon;
import java.util.HashMap;
import java.util.Map;

public class PhotonAtomCollisonExpert
implements CollisionExpert {
    private Object[] bodies = new Object[2];
    private Map classifiedBodies = new HashMap();

    public PhotonAtomCollisonExpert() {
        this.classifiedBodies.put(Photon.class, null);
        this.classifiedBodies.put(Atom.class, null);
    }

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        if (CollisionUtil.areConformantToClasses(collidable, collidable2, Photon.class, Atom.class)) {
            this.bodies[0] = collidable;
            this.bodies[1] = collidable2;
            CollisionUtil.classifyBodies(this.bodies, this.classifiedBodies);
            Atom atom = (Atom)this.classifiedBodies.get(Atom.class);
            Photon photon = (Photon)this.classifiedBodies.get(Photon.class);
            if (atom != null && photon != null && photon.getPosition().distanceSq(atom.getPosition()) < atom.getRadius() * atom.getRadius()) {
                atom.collideWithPhoton(photon);
            }
        }
        return false;
    }
}

