/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class ButtonIconSet {
    private double dx;
    private double dy;
    private int buttonWidth;
    private int buttonHeight;

    public ButtonIconSet(int n, int n2) {
        this.buttonWidth = n;
        this.buttonHeight = n2;
        this.dx = n2 / 6;
        this.dy = n2 / 6;
    }

    public Shape createPlayIconShape() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d = this.buttonWidth;
        double d2 = this.buttonHeight;
        doubleGeneralPath.moveTo(d / 2.0 + this.dx + this.dx / 4.0, d2 / 2.0);
        doubleGeneralPath.lineToRelative(-this.dx * 2.0, this.dy);
        doubleGeneralPath.lineToRelative(0.0, -2.0 * this.dy);
        doubleGeneralPath.lineToRelative(2.0 * this.dx, this.dy);
        return doubleGeneralPath.getGeneralPath();
    }

    public Shape createPauseIconShape() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d = this.buttonWidth;
        double d2 = this.buttonHeight;
        double d3 = this.dx / 4.0;
        double d4 = this.dx * 0.8;
        doubleGeneralPath.moveTo(d / 2.0 - d3, d2 / 2.0 - this.dy);
        this.moveInSquare(doubleGeneralPath, d4);
        doubleGeneralPath.moveTo(d / 2.0 + d4 + d3, d2 / 2.0 - this.dy);
        this.moveInSquare(doubleGeneralPath, d4);
        return doubleGeneralPath.getGeneralPath();
    }

    private void moveInSquare(DoubleGeneralPath doubleGeneralPath, double d) {
        doubleGeneralPath.lineToRelative(0.0, 2.0 * this.dy);
        doubleGeneralPath.lineToRelative(-d, 0.0);
        doubleGeneralPath.lineToRelative(0.0, -2.0 * this.dy);
        doubleGeneralPath.lineToRelative(d, 0.0);
    }

    public Shape createStepIconShape() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d = this.buttonWidth;
        double d2 = this.buttonHeight;
        double d3 = this.dx / 5.0;
        double d4 = this.dx * 0.8;
        doubleGeneralPath.moveTo(d / 2.0 - d3, d2 / 2.0 - this.dy);
        doubleGeneralPath.lineToRelative(0.0, 2.0 * this.dy);
        doubleGeneralPath.lineToRelative(-d4 * 0.8, 0.0);
        doubleGeneralPath.lineToRelative(0.0, -2.0 * this.dy);
        doubleGeneralPath.lineToRelative(d4 * 0.8, 0.0);
        doubleGeneralPath.moveTo(d / 2.0 + d3, d2 / 2.0 - this.dy);
        doubleGeneralPath.lineToRelative(0.0, 2.0 * this.dy);
        doubleGeneralPath.lineToRelative(d4 * 1.5, -this.dy);
        doubleGeneralPath.lineToRelative(-d4 * 1.5, -this.dy);
        return doubleGeneralPath.getGeneralPath();
    }

    public Shape createStepBackIconShape() {
        Shape shape = this.createStepIconShape();
        double d = shape.getBounds2D().getMaxX() + ((double)this.buttonWidth - shape.getBounds2D().getMaxX());
        AffineTransform affineTransform = new AffineTransform(-1.0, 0.0, 0.0, 1.0, d, 1.0);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Shape createRewindIconShape() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d = this.buttonWidth;
        double d2 = this.buttonHeight;
        double d3 = this.dx / 5.0;
        double d4 = this.dx * 0.8;
        doubleGeneralPath.moveTo(d / 2.0 - d3 - d4 / 1.5, d2 / 2.0 - this.dy);
        doubleGeneralPath.lineToRelative(0.0, 2.0 * this.dy);
        doubleGeneralPath.lineToRelative(-d4 * 0.8, 0.0);
        doubleGeneralPath.lineToRelative(0.0, -2.0 * this.dy);
        doubleGeneralPath.lineToRelative(d4 * 0.8, 0.0);
        doubleGeneralPath.moveTo(d / 2.0 + d3 + d4 - d4 / 1.5, d2 / 2.0 - this.dy);
        doubleGeneralPath.lineToRelative(0.0, 2.0 * this.dy);
        doubleGeneralPath.lineToRelative(-d4 * 1.5, -this.dy);
        doubleGeneralPath.lineToRelative(d4 * 1.5, -this.dy);
        doubleGeneralPath.moveTo(d / 2.0 + d3 + d4 - d4 / 2.0 + d4 + d3 * 1.43, d2 / 2.0 - this.dy);
        doubleGeneralPath.lineToRelative(0.0, 2.0 * this.dy);
        doubleGeneralPath.lineToRelative(-d4 * 1.5, -this.dy);
        doubleGeneralPath.lineToRelative(d4 * 1.5, -this.dy);
        return doubleGeneralPath.getGeneralPath();
    }
}

