/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<T>
implements Iterable<T> {
    public abstract T get();

    public abstract boolean isSome();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class None<T>
    extends Option<T> {
        @Override
        public T get() {
            throw new UnsupportedOperationException("Cannot get value on none.");
        }

        @Override
        public boolean isSome() {
            return false;
        }

        public String toString() {
            return "None";
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayList().iterator();
        }

        public boolean equals(Object object) {
            return object instanceof None;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Some<T>
    extends Option<T> {
        private final T value;

        public Some(T t) {
            this.value = t;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isSome() {
            return true;
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayList<T>(){
                {
                    this.add(Some.this.value);
                }
            }.iterator();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Some some = (Some)object;
            return !(this.value != null ? !this.value.equals(some.value) : some.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

