/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.dialogs;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.dialogs.ContribLicenseDialog;
import edu.colorado.phet.common.phetcommon.resources.DefaultResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.util.AnnotationParser;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CreditsDialog
extends PaintImmediateDialog {
    private static final Dimension SCROLLPANE_SIZE = new Dimension(525, 300);
    private static final String TITLE = PhetCommonResources.getString("Common.About.CreditsDialog.Title");
    private static final String CLOSE_BUTTON = PhetCommonResources.getString("Common.choice.close");
    private static final String LICENSE_DETAILS_TITLE = PhetCommonResources.getString("Common.About.CreditsDialog.licenseDetails");
    private final ThirdPartySoftwareCredits thirdPartySoftwareCredits;

    public CreditsDialog(Dialog dialog, String string) {
        super(dialog, TITLE);
        this.setModal(true);
        this.thirdPartySoftwareCredits = new ThirdPartySoftwareCredits(string);
        String string2 = new DevelopmentTeamCredits(string).createHTMLFragment();
        String string3 = new TranslationCredits(string).createHTMLFragment();
        String string4 = this.thirdPartySoftwareCredits.createHTMLFragment();
        String string5 = string2 + "<br><br>";
        if (string3 != null) {
            string5 = string5 + string3 + "<br><br>";
        }
        string5 = string5 + string4;
        String string6 = HTMLUtils.createStyledHTMLFromFragment(string5);
        InteractiveHTMLPane interactiveHTMLPane = new InteractiveHTMLPane(this, string6);
        JScrollPane jScrollPane = new JScrollPane(interactiveHTMLPane);
        jScrollPane.setPreferredSize(SCROLLPANE_SIZE);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(CLOSE_BUTTON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreditsDialog.this.setVisible(false);
                CreditsDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setContentPane(jPanel2);
        this.pack();
        SwingUtils.centerDialogInParent(this);
        interactiveHTMLPane.setCaretPosition(0);
    }

    private static class DevelopmentTeamCredits {
        private static final String TITLE = PhetCommonResources.getString("Common.About.CreditsDialog.PhetDevelopmentTeam");
        private static final String LABEL_LEAD_DESIGN = PhetCommonResources.getString("Common.About.CreditsDialog.lead-design");
        private static final String LABEL_SOFTWARE_DEVELOPMENT = PhetCommonResources.getString("Common.About.CreditsDialog.software-development");
        private static final String LABEL_DESIGN_TEAM = PhetCommonResources.getString("Common.About.CreditsDialog.design-team");
        private static final String LABEL_INTERVIEWS = PhetCommonResources.getString("Common.About.CreditsDialog.interviews");
        private final String projectName;

        public DevelopmentTeamCredits(String string) {
            this.projectName = string;
        }

        public String createHTMLFragment() {
            String string = this.readCreditsFile();
            if (string == null) {
                return "missing credits.txt";
            }
            AnnotationParser.Annotation annotation = AnnotationParser.parse(string);
            HashMap hashMap = annotation.getMap();
            ArrayList arrayList = annotation.getKeyOrdering();
            StringBuffer stringBuffer = new StringBuffer("<b>" + TITLE + "</b><br><br>");
            for (String string2 : arrayList) {
                String string3;
                String string4 = this.map(string2, string3 = (String)hashMap.get(string2));
                if (string4 == null) continue;
                stringBuffer.append(string4 + "<br>");
            }
            return stringBuffer.toString();
        }

        private String readCreditsFile() {
            String string = null;
            String string2 = this.projectName + "/" + "credits.txt";
            try {
                string = new DefaultResourceLoader().getResourceAsString(string2);
            }
            catch (IOException iOException) {
                System.err.println(this.getClass().getName() + ": missing " + string2);
            }
            return string;
        }

        private String map(String string, String string2) {
            if (string.equals("lead-design")) {
                return LABEL_LEAD_DESIGN + ": " + string2;
            }
            if (string.equals("software-development")) {
                return LABEL_SOFTWARE_DEVELOPMENT + ": " + string2;
            }
            if (string.equals("design-team")) {
                return LABEL_DESIGN_TEAM + ": " + string2;
            }
            if (string.equals("interviews")) {
                return LABEL_INTERVIEWS + ": " + string2;
            }
            System.err.println(this.getClass().getName() + ": unrecognized key encountered in " + "credits.txt" + ": " + string);
            return null;
        }
    }

    private class InteractiveHTMLPane
    extends HTMLUtils.HTMLEditorPane {
        public InteractiveHTMLPane(final Dialog dialog, String string) {
            super(string);
            this.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (CreditsDialog.this.thirdPartySoftwareCredits.isThirdPartyLicenseURL(hyperlinkEvent.getURL())) {
                            String string = CreditsDialog.this.thirdPartySoftwareCredits.getThirdPartyLicenseHTML(hyperlinkEvent.getURL());
                            ContribLicenseDialog contribLicenseDialog = new ContribLicenseDialog(dialog, LICENSE_DETAILS_TITLE, string);
                            contribLicenseDialog.setVisible(true);
                        } else {
                            PhetServiceManager.showWebPage(hyperlinkEvent.getURL());
                        }
                    }
                }
            });
        }
    }

    private static class ThirdPartySoftwareCredits {
        private static final String TITLE = PhetCommonResources.getString("Common.About.CreditsDialog.UsesThirdPartySoftware");
        private final String projectName;

        public ThirdPartySoftwareCredits(String string) {
            this.projectName = string;
        }

        public String createHTMLFragment() {
            String string = this.readLicenseInfoFile();
            if (string == null) {
                return "missing license-info.txt";
            }
            AnnotationParser.Annotation[] annotationArray = AnnotationParser.getAnnotations(string);
            StringBuffer stringBuffer = new StringBuffer("<b>" + TITLE + "</b><br><br>");
            for (int i = 0; i < annotationArray.length; ++i) {
                String string2 = annotationArray[i].getId();
                String string3 = annotationArray[i].get("name");
                String string4 = annotationArray[i].get("description");
                String string5 = annotationArray[i].get("copyright");
                String string6 = annotationArray[i].get("website");
                String string7 = annotationArray[i].get("license");
                String string8 = annotationArray[i].get("licensefile");
                stringBuffer.append(string3 + ", " + string4 + "<br>");
                stringBuffer.append("&copy;&nbsp;" + string5 + " - " + string6 + "<br>");
                if (string7 != null) {
                    String string9 = this.projectName + "/" + "contrib-licenses" + "/" + string2 + "-" + string8;
                    stringBuffer.append("<a href=\"file://credits/" + string9 + "\">" + string7 + "<a>");
                } else {
                    stringBuffer.append("license not found");
                }
                stringBuffer.append("<br><br>");
            }
            return stringBuffer.toString();
        }

        private String readLicenseInfoFile() {
            String string = null;
            String string2 = this.projectName + "/" + "contrib-licenses" + "/" + "license-info.txt";
            try {
                string = new DefaultResourceLoader().getResourceAsString(string2);
            }
            catch (IOException iOException) {
                System.err.println(this.getClass().getName() + ": missing  " + string2 + " - Did you generate license info for this sim, using PhetBuildGUI->Misc->Generate License Info ?");
            }
            return string;
        }

        public boolean isThirdPartyLicenseURL(URL uRL) {
            return uRL.getProtocol().equals("file") && uRL.getAuthority().equals("credits");
        }

        public String getThirdPartyLicenseHTML(URL uRL) {
            String string = uRL.getPath();
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            String string2 = null;
            try {
                string2 = new DefaultResourceLoader().getResourceAsString(string);
            }
            catch (Exception exception) {
                return "missing " + string;
            }
            if (!string2.trim().startsWith("<html")) {
                string2 = HTMLUtils.createStyledHTMLFromFragment(string2);
                string2 = string2.replaceAll("\\n", "<br>");
            }
            return string2;
        }
    }

    private static class TranslationCredits {
        private static final String TITLE = PhetCommonResources.getString("Common.About.CreditsDialog.TranslationCreditsTitle");
        private final String projectName;

        public TranslationCredits(String string) {
            this.projectName = string;
        }

        public String createHTMLFragment() {
            String string = this.readCredits();
            if (string != null) {
                return "<b>" + TITLE + "</b><br><br>" + string + "<br>";
            }
            return null;
        }

        private String readCredits() {
            PhetResources phetResources = new PhetResources(this.projectName);
            String string = phetResources.getLocalizedProperties().getString("ksu.credits", false);
            if (!string.equals("ksu.credits")) {
                return string;
            }
            string = phetResources.getLocalizedProperties().getString("translation.credits", false);
            if (!string.equals("translation.credits")) {
                return string;
            }
            return null;
        }
    }
}

