/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.controls;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class SpectrumGraphic
extends CompositePhetGraphic {
    private static Color invisibleColor = new Color(64, 64, 64);
    private CompositePhetGraphic uvGraphic;
    private PhetGraphic visibleGraphic;
    private CompositePhetGraphic irGraphic;

    public SpectrumGraphic(Component component, double d, double d2) {
        super(component);
        PhetTextGraphic phetTextGraphic;
        PhetShapeGraphic phetShapeGraphic;
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.visibleGraphic = new PhetImageGraphic(component, "images/spectrum.png");
        double d3 = 400.0;
        double d4 = 380.0 - d;
        double d5 = d2 - 780.0;
        int n = (int)(d4 / d3 * (double)this.visibleGraphic.getWidth());
        int n2 = (int)(d5 / d3 * (double)this.visibleGraphic.getWidth());
        PhetFont phetFont = new PhetFont(1, 14);
        if (n > 0) {
            phetShapeGraphic = new PhetShapeGraphic(component, new Rectangle(n, this.visibleGraphic.getHeight()), invisibleColor);
            phetTextGraphic = new PhetTextGraphic(component, phetFont, PhetCommonResources.getString("wavelength.uv"), Color.white);
            phetTextGraphic.setLocation(n / 2 - 10, 10);
            this.uvGraphic = new CompositePhetGraphic(component);
            this.uvGraphic.addGraphic(phetShapeGraphic);
            this.uvGraphic.addGraphic(phetTextGraphic);
            this.addGraphic(this.uvGraphic);
        }
        this.visibleGraphic.setLocation(n, 0);
        this.addGraphic(this.visibleGraphic);
        if (n2 > 0) {
            phetShapeGraphic = new PhetShapeGraphic(component, new Rectangle(n2, this.visibleGraphic.getHeight()), invisibleColor);
            phetTextGraphic = new PhetTextGraphic(component, phetFont, PhetCommonResources.getString("wavelength.ir"), Color.white);
            phetTextGraphic.setLocation(n2 / 2 - 5, 10);
            this.irGraphic = new CompositePhetGraphic(component);
            this.irGraphic.addGraphic(phetShapeGraphic);
            this.irGraphic.addGraphic(phetTextGraphic);
            this.irGraphic.setLocation(n + this.visibleGraphic.getWidth(), 0);
            this.addGraphic(this.irGraphic);
        }
    }
}

