/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.wireframe;

import edu.colorado.phet.hydrogenatom.wireframe.Wireframe3D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Wireframe3DNode
extends PNode {
    private Wireframe3D _wireframe;
    private PropertyChangeListener _listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "bounds" || string == "strokeWidth") {
                Wireframe3DNode.this.updateBounds();
            }
        }
    };

    public Wireframe3DNode(Wireframe3D wireframe3D) {
        this.setWireframe(wireframe3D);
    }

    public void setWireframe(Wireframe3D wireframe3D) {
        if (this._wireframe != null) {
            this._wireframe.removePropertyChangeListener(this._listener);
        }
        this._wireframe = wireframe3D;
        this._wireframe.addPropertyChangeListener(this._listener);
        this.updateBounds();
        this.repaint();
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        this._wireframe.paint(pPaintContext.getGraphics());
    }

    private void updateBounds() {
        float f = this._wireframe.getStrokeWidth();
        double d = this._wireframe.getTXMin() - f / 2.0f;
        double d2 = this._wireframe.getTYMin() - f / 2.0f;
        double d3 = this._wireframe.getTXMax() - this._wireframe.getTXMin() + f;
        double d4 = this._wireframe.getTYMax() - this._wireframe.getTYMin() + f;
        this.setBounds(d, d2, d3, d4);
    }
}

