/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.wireframe;

import edu.colorado.phet.hydrogenatom.wireframe.Matrix3D;
import edu.colorado.phet.hydrogenatom.wireframe.Vertex3D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;

public class Wireframe3D {
    private Matrix3D _matrix = new Matrix3D();
    private float[] _verticies = new float[300];
    private int _numberOfVerticies = 0;
    private int[] _lines = new int[100];
    private int _numberOfLines = 0;
    private float[] _transformedVerticies = new float[this._verticies.length];
    private float _xmin = 0.0f;
    private float _xmax = 0.0f;
    private float _ymin = 0.0f;
    private float _ymax = 0.0f;
    private float _zmin = 0.0f;
    private float _zmax = 0.0f;
    private float _txmin = 0.0f;
    private float _txmax = 0.0f;
    private float _tymin = 0.0f;
    private float _tymax = 0.0f;
    private float _tzmin = 0.0f;
    private float _tzmax = 0.0f;
    private boolean _transformed = false;
    private boolean _untransformedBoundsDirty = true;
    private Color[] _palette = Wireframe3D.createColorPalette(Color.BLACK, Color.GRAY);
    private boolean _antialiased = true;
    private float _strokeWidth = 1.0f;
    private Stroke _stroke = Wireframe3D.createStroke(this._strokeWidth);
    private Line2D _line = new Line2D.Float();
    private EventListenerList _listenerList = new EventListenerList();

    public Wireframe3D() {
    }

    public Wireframe3D(Vertex3D[] vertex3DArray) {
        this();
        for (int i = 0; i < vertex3DArray.length; ++i) {
            this.addVertex(vertex3DArray[i]);
        }
    }

    public void setMatrix(Matrix3D matrix3D) {
        this._matrix = matrix3D;
        this._transformed = false;
        this.transform();
    }

    public Matrix3D getMatrix() {
        return this._matrix;
    }

    public void setColors(Color color, Color color2) {
        this._palette = Wireframe3D.createColorPalette(color, color2);
    }

    public void setStrokeWidth(float f) {
        if (f != this._strokeWidth) {
            this._strokeWidth = f;
            this._stroke = Wireframe3D.createStroke(f);
            this.notifyStrokeWidthChange();
        }
    }

    public float getStrokeWidth() {
        return this._strokeWidth;
    }

    public float getXMax() {
        this.updateUntransformedBounds();
        return this._xmax;
    }

    public float getXMin() {
        this.updateUntransformedBounds();
        return this._xmin;
    }

    public float getYMax() {
        this.updateUntransformedBounds();
        return this._ymax;
    }

    public float getYMin() {
        this.updateUntransformedBounds();
        return this._ymin;
    }

    public float getZMax() {
        this.updateUntransformedBounds();
        return this._zmax;
    }

    public float getZMin() {
        this.updateUntransformedBounds();
        return this._zmin;
    }

    public float getTXMax() {
        this.transform();
        return this._txmax;
    }

    public float getTXMin() {
        this.transform();
        return this._txmin;
    }

    public float getTYMax() {
        this.transform();
        return this._tymax;
    }

    public float getTYMin() {
        this.transform();
        return this._tymin;
    }

    public void paint(Graphics2D graphics2D) {
        if (this._numberOfVerticies == 0 || this._numberOfLines == 0) {
            return;
        }
        if (!this._transformed) {
            this.transform();
        }
        Color color = graphics2D.getColor();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this._antialiased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setStroke(this._stroke);
        int n = -1;
        for (int i = 0; i < this._numberOfLines; ++i) {
            int n2 = this._lines[i];
            int n3 = (n2 >> 16 & 0xFFFF) * 3;
            int n4 = (n2 & 0xFFFF) * 3;
            float f = this._transformedVerticies[n3 + 2] + (this._transformedVerticies[n3 + 2] - this._transformedVerticies[n4 + 2]) / 2.0f;
            int n5 = (int)((float)(this._palette.length - 1) * ((f - this._tzmin) / (this._tzmax - this._tzmin)));
            assert (n5 >= 0 && n5 < this._palette.length);
            if (n5 != n) {
                n = n5;
                graphics2D.setColor(this._palette[n5]);
            }
            this._line.setLine(this._transformedVerticies[n3], this._transformedVerticies[n3 + 1], this._transformedVerticies[n4], this._transformedVerticies[n4 + 1]);
            graphics2D.draw(this._line);
        }
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setStroke(stroke);
    }

    public int addVerticies(Vertex3D[] vertex3DArray) {
        int n = 0;
        for (int i = 0; i < vertex3DArray.length; ++i) {
            n = this.addVertex(vertex3DArray[i]);
        }
        return n;
    }

    public int addVertex(Vertex3D vertex3D) {
        return this.addVertex(vertex3D.getX(), vertex3D.getY(), vertex3D.getZ());
    }

    public int addVertex(float f, float f2, float f3) {
        int n = this._verticies.length / 3;
        if (this._numberOfVerticies >= n) {
            float[] fArray = new float[this._verticies.length * 2];
            System.arraycopy(this._verticies, 0, fArray, 0, this._verticies.length);
            this._verticies = fArray;
        }
        int n2 = this._numberOfVerticies * 3;
        this._verticies[n2] = f;
        this._verticies[n2 + 1] = f2;
        this._verticies[n2 + 2] = f3;
        ++this._numberOfVerticies;
        this._untransformedBoundsDirty = true;
        return this._numberOfVerticies;
    }

    public int addLine(int n, int n2) {
        if (n >= this._numberOfVerticies) {
            throw new IllegalArgumentException("line index1 out of range: " + n);
        }
        if (n2 >= this._numberOfVerticies) {
            throw new IllegalArgumentException("line index2 out of range: " + n2);
        }
        if (this._numberOfLines >= this._lines.length) {
            int[] nArray = new int[this._lines.length * 2];
            System.arraycopy(this._lines, 0, nArray, 0, this._lines.length);
            this._lines = nArray;
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        this._lines[this._numberOfLines] = n << 16 | n2;
        ++this._numberOfLines;
        return this._numberOfLines;
    }

    public void reset() {
        this._numberOfVerticies = 0;
        this._numberOfLines = 0;
        this._untransformedBoundsDirty = true;
        this._transformed = false;
    }

    private void transform() {
        if (this._transformed || this._numberOfVerticies == 0) {
            return;
        }
        if (this._transformedVerticies.length < this._verticies.length) {
            this._transformedVerticies = new float[this._verticies.length];
        }
        this._matrix.transform(this._verticies, this._transformedVerticies, this._numberOfVerticies);
        this.updateTransformedBounds();
        this._transformed = true;
        this.notifyBoundsChange();
    }

    private void updateUntransformedBounds() {
        float f;
        float f2;
        float f3;
        if (!this._untransformedBoundsDirty || this._numberOfVerticies == 0) {
            return;
        }
        float[] fArray = this._verticies;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this._numberOfVerticies * 3;
        while ((n -= 3) > 0) {
            float f7 = fArray[n];
            if (f7 < f3) {
                f3 = f7;
            } else if (f7 > f4) {
                f4 = f7;
            }
            float f8 = fArray[n + 1];
            if (f8 < f2) {
                f2 = f8;
            } else if (f8 > f5) {
                f5 = f8;
            }
            float f9 = fArray[n + 2];
            if (f9 < f) {
                f = f9;
                continue;
            }
            if (!(f9 > f6)) continue;
            f6 = f9;
        }
        this._xmax = f4;
        this._xmin = f3;
        this._ymax = f5;
        this._ymin = f2;
        this._zmax = f6;
        this._zmin = f;
    }

    private void updateTransformedBounds() {
        float f;
        float f2;
        float f3;
        if (this._transformed || this._numberOfVerticies == 0) {
            return;
        }
        float[] fArray = this._transformedVerticies;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this._numberOfVerticies * 3;
        while ((n -= 3) > 0) {
            float f7 = fArray[n];
            if (f7 < f3) {
                f3 = f7;
            } else if (f7 > f4) {
                f4 = f7;
            }
            float f8 = fArray[n + 1];
            if (f8 < f2) {
                f2 = f8;
            } else if (f8 > f5) {
                f5 = f8;
            }
            float f9 = fArray[n + 2];
            if (f9 < f) {
                f = f9;
                continue;
            }
            if (!(f9 > f6)) continue;
            f6 = f9;
        }
        this._txmax = f4;
        this._txmin = f3;
        this._tymax = f5;
        this._tymin = f2;
        this._tzmax = f6;
        this._tzmin = f;
    }

    private static Stroke createStroke(float f) {
        return new BasicStroke(f);
    }

    private static Color[] createColorPalette(Color color, Color color2) {
        Color[] colorArray = new Color[16];
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getRed();
        int n5 = color2.getGreen();
        int n6 = color2.getBlue();
        float f = (float)(n - n4) / 15.0f;
        float f2 = (float)(n2 - n5) / 15.0f;
        float f3 = (float)(n3 - n6) / 15.0f;
        for (int i = 0; i < 16; ++i) {
            float f4 = ((float)n - (float)i * f) / 255.0f;
            float f5 = ((float)n2 - (float)i * f2) / 255.0f;
            float f6 = ((float)n3 - (float)i * f3) / 255.0f;
            colorArray[i] = new Color(f4, f5, f6);
        }
        return colorArray;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    private void notifyBoundsChange() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "bounds", null, null);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }

    private void notifyStrokeWidthChange() {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "strokeWidth", null, null);
        this.firePropertyChangeEvent(propertyChangeEvent);
    }
}

