/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.particle;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.particle.NeutronNode;
import edu.colorado.phet.hydrogenatom.view.particle.ProtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.util.Observable;
import java.util.Observer;

public class AlphaParticleNode
extends PhetPNode
implements Observer {
    private static Image IMAGE = null;
    private static boolean ROTATE_TO_ORIENTATION = false;
    private AlphaParticle _alphaParticle;

    public AlphaParticleNode(AlphaParticle alphaParticle) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        Image image = AlphaParticleNode.createImage();
        PImage pImage = new PImage(image);
        this.addChild(pImage);
        pImage.setOffset(-pImage.getFullBounds().getWidth() / 2.0, -pImage.getFullBounds().getHeight() / 2.0);
        this._alphaParticle = alphaParticle;
        this._alphaParticle.addObserver(this);
    }

    public static final Image createImage() {
        if (IMAGE == null) {
            PNode pNode = new PNode();
            ProtonNode protonNode = new ProtonNode();
            ProtonNode protonNode2 = new ProtonNode();
            NeutronNode neutronNode = new NeutronNode();
            NeutronNode neutronNode2 = new NeutronNode();
            pNode.addChild(protonNode2);
            pNode.addChild(neutronNode2);
            pNode.addChild(protonNode);
            pNode.addChild(neutronNode);
            double d = 0.667 * protonNode.getFullBounds().getWidth();
            double d2 = 0.667 * protonNode.getFullBounds().getHeight();
            protonNode.setOffset(0.0, 0.0);
            protonNode2.setOffset(d, d2);
            neutronNode.setOffset(d, 0.0);
            neutronNode2.setOffset(0.0, d2);
            IMAGE = pNode.toImage();
        }
        return IMAGE;
    }

    public void update(Observable observable, Object object) {
        this.update();
    }

    private void update() {
        if (ROTATE_TO_ORIENTATION) {
            this.setRotation(this._alphaParticle.getOrientation());
        }
        this.setOffset(HAModelViewTransform.transform(this._alphaParticle.getPositionRef()));
    }
}

