/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.hydrogenatom.model.ExperimentModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class ExperimentNode
extends PhetPNode
implements Observer {
    private static final Font FONT = new PhetFont(0, 100);
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final Color BOX_FILL_COLOR = new Color(20, 20, 20);
    private static final Color BOX_STROKE_COLOR = Color.WHITE;
    private static final Stroke BOX_STROKE = new BasicStroke(2.0f);
    private static final Dimension BOX_SIZE = new Dimension(125, 125);
    private ExperimentModel _atom;

    public ExperimentNode(ExperimentModel experimentModel) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._atom = experimentModel;
        this._atom.addObserver(this);
        double d = ExperimentNode.BOX_SIZE.width;
        double d2 = ExperimentNode.BOX_SIZE.height;
        PPath pPath = new PPath(new Rectangle2D.Double(-d / 2.0, -d2 / 2.0, d, d2));
        pPath.setPaint(BOX_FILL_COLOR);
        pPath.setStroke(BOX_STROKE);
        pPath.setStrokePaint(BOX_STROKE_COLOR);
        pPath.setOffset(0.0, 0.0);
        PText pText = new PText("?");
        pText.setFont(FONT);
        pText.setTextPaint(TEXT_COLOR);
        double d3 = pPath.getX() + (pPath.getWidth() / 2.0 - pText.getWidth() / 2.0);
        double d4 = pPath.getY() + (pPath.getHeight() / 2.0 - pText.getHeight() / 2.0);
        pText.setOffset(d3, d4);
        this.addChild(pPath);
        this.addChild(pText);
        this.setOffset(HAModelViewTransform.transform(this._atom.getPositionRef()));
    }

    public void update(Observable observable, Object object) {
    }
}

