/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class BoxOfHydrogenNode
extends PImage {
    private static final Paint BOX_FRONT_PAINT = Color.GRAY;
    private static final Color TOP_COLOR_FRONT = Color.GRAY;
    private static final Color TOP_COLOR_BACK = Color.DARK_GRAY;
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Color STROKE_COLOR = Color.BLACK;
    public static final Color TINY_BOX_FILL_COLOR = HAConstants.ANIMATION_BOX_COLOR;
    public static final Color TINY_BOX_STROKE_COLOR = HAConstants.ANIMATION_BOX_STROKE_COLOR;
    public static final Stroke TINY_BOX_STROKE = new BasicStroke(2.0f);
    private PPath _tinyBoxNode;

    public BoxOfHydrogenNode(Dimension dimension, Dimension dimension2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        PNode pNode = new PNode();
        float f = dimension.width;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.15f * f, 0.0f);
        generalPath.lineTo(0.85f * f, 0.0f);
        generalPath.lineTo(f, 10.0f);
        generalPath.lineTo(0.0f, 10.0f);
        generalPath.closePath();
        Serializable serializable = new PPath();
        serializable.setPathTo(generalPath);
        serializable.setPaint(new GradientPaint(0.0f, 0.0f, TOP_COLOR_BACK, 0.0f, 10.0f, TOP_COLOR_FRONT));
        serializable.setStroke(STROKE);
        serializable.setStrokePaint(STROKE_COLOR);
        PNode pNode2 = new PPath(new Rectangle2D.Double(0.0, 10.0, dimension.width, dimension.height));
        pNode2.setPaint(BOX_FRONT_PAINT);
        ((PPath)pNode2).setStroke(STROKE);
        ((PPath)pNode2).setStrokePaint(STROKE_COLOR);
        pNode.addChild(pNode2);
        pNode.addChild((PNode)serializable);
        this._tinyBoxNode = new PPath(new Rectangle2D.Double(0.0, 0.0, dimension2.width, dimension2.height));
        this._tinyBoxNode.setPaint(TINY_BOX_FILL_COLOR);
        this._tinyBoxNode.setStrokePaint(TINY_BOX_STROKE_COLOR);
        this._tinyBoxNode.setStroke(TINY_BOX_STROKE);
        HTMLNode hTMLNode = new HTMLNode();
        hTMLNode.setHTML(HAResources.getString("label.boxOfHydrogen"));
        hTMLNode.setHTMLColor(HAConstants.CANVAS_LABELS_COLOR);
        int n = HAResources.getInt("boxOfHydrogen.font.size", 16);
        serializable = new PhetFont(1, n);
        hTMLNode.setFont((Font)serializable);
        pNode2 = new PComposite();
        pNode2.addChild(pNode);
        pNode2.addChild(this._tinyBoxNode);
        pNode2.addChild(hTMLNode);
        double d = hTMLNode.getFullBounds().getWidth();
        double d2 = pNode.getFullBounds().getWidth();
        if (d2 > d) {
            hTMLNode.setOffset((d2 - d) / 2.0, 0.0);
            pNode.setOffset(0.0, hTMLNode.getFullBounds().getHeight() + 5.0);
        } else {
            hTMLNode.setOffset(0.0, 0.0);
            pNode.setOffset((d - d2) / 2.0, hTMLNode.getFullBounds().getHeight() + 5.0);
        }
        double d3 = pNode.getFullBounds().getX() + 0.6 * pNode.getFullBounds().getWidth();
        double d4 = pNode.getFullBounds().getY() + 0.3 * pNode.getFullBounds().getHeight();
        this._tinyBoxNode.setOffset(d3, d4);
        this.setImage(pNode2.toImage());
    }

    public PBounds getTinyBoxGlobalBounds() {
        PBounds pBounds = this._tinyBoxNode.getFullBounds();
        Point2D point2D = this.localToGlobal(pBounds.getOrigin());
        Dimension2D dimension2D = this.localToGlobal(pBounds.getSize());
        PBounds pBounds2 = new PBounds(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
        return pBounds2;
    }
}

