/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view;

import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class AnimationBoxNode
extends PClip {
    public static final Stroke STROKE = new BasicStroke(2.0f);
    public static final Color STROKE_COLOR = Color.WHITE;
    private PLayer _atomLayer;
    private PLayer _traceLayer;
    private PLayer _particleLayer;
    private PLayer _topLayer;

    public AnimationBoxNode(Dimension dimension) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height);
        this.setPathTo(double_);
        this.setPaint(HAConstants.ANIMATION_BOX_COLOR);
        this.setStroke(STROKE);
        this.setStrokePaint(HAConstants.ANIMATION_BOX_STROKE_COLOR);
        this._atomLayer = new PLayer();
        this.addChild(this._atomLayer);
        this._traceLayer = new PLayer();
        this.addChild(this._traceLayer);
        this._particleLayer = new PLayer();
        this.addChild(this._particleLayer);
        this._topLayer = new PLayer();
        this.addChild(this._topLayer);
    }

    public PLayer getAtomLayer() {
        return this._atomLayer;
    }

    public PLayer getTraceLayer() {
        return this._traceLayer;
    }

    public PLayer getParticleLayer() {
        return this._particleLayer;
    }

    public PLayer getTopLayer() {
        return this._topLayer;
    }
}

