/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.util.RandomUtils;
import java.awt.geom.Point2D;

public class SolarSystemModel
extends AbstractHydrogenAtom {
    private static final double ELECTRON_ANGLE_DELTA = Math.toRadians(16.0);
    private Point2D _electronOffset = new Point2D.Double();
    private double _electronDistance = 150.0;
    private double _electronAngle = RandomUtils.nextAngle();
    private double _electronAngleDelta = ELECTRON_ANGLE_DELTA;
    private boolean _destroyed = false;

    public SolarSystemModel(Point2D point2D) {
        super(point2D, 0.0);
        this.setElectronPosition(this._electronAngle, this._electronDistance);
    }

    public Point2D getElectronOffset() {
        return this._electronOffset;
    }

    public double getElectronDistanceFromCenter() {
        double d = this._electronOffset.getX();
        double d2 = this._electronOffset.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public void stepInTime(double d) {
        if (!this._destroyed) {
            this._electronAngle += this._electronAngleDelta * d;
            this._electronAngleDelta *= 1.008;
            this._electronDistance -= 4.0 * d;
            if (this._electronDistance <= 5.0) {
                this._electronDistance = 0.0;
            }
            this.setElectronPosition(this._electronAngle, this._electronDistance);
            this.notifyObservers("electronOffset");
            if (this._electronDistance == 0.0) {
                this._destroyed = true;
                this.notifyObservers("atomDestroyed");
            }
        }
    }

    private void setElectronPosition(double d, double d2) {
        double d3 = d2 * Math.cos(d);
        double d4 = d2 * Math.sin(d);
        this._electronOffset.setLocation(d3, d4);
    }
}

