/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.Photon;
import edu.colorado.phet.hydrogenatom.model.RutherfordScattering;
import edu.colorado.phet.hydrogenatom.util.RandomUtils;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class PlumPuddingModel
extends AbstractHydrogenAtom {
    private int _numberOfPhotonsAbsorbed = 0;
    private double _radius;
    private Point2D _electronOffset;
    private Point2D _electronPosition;
    private Line2D _electronLine;
    private boolean _electronDirectionPositive;
    private boolean _electronIsMoving;
    private int _numberOfZeroCrossings;
    private double _previousAmplitude;
    private Random _randomAbsorption;
    private Random _randomEmission;

    public PlumPuddingModel(Point2D point2D) {
        this(point2D, 30.0);
        this._randomAbsorption = new Random();
        this._randomEmission = new Random();
    }

    private PlumPuddingModel(Point2D point2D, double d) {
        super(point2D, 0.0);
        this._radius = d;
        this._electronOffset = new Point2D.Double();
        this._electronPosition = new Point2D.Double();
        this._electronLine = new Line2D.Double();
        this._electronIsMoving = false;
        this._numberOfZeroCrossings = 0;
        this._previousAmplitude = 0.0;
        this.updateElectronLine();
    }

    public double getRadius() {
        return this._radius;
    }

    public Point2D getElectronOffsetRef() {
        return this._electronOffset;
    }

    private void setElectronOffset(double d, double d2) {
        this._electronOffset.setLocation(d, d2);
        this._electronPosition.setLocation(this.getX() + d, this.getY() + d2);
        this.notifyObservers("electronOffset");
    }

    private void updateElectronLine() {
        double d = RandomUtils.nextAngle();
        double d2 = Math.abs(this._radius * Math.sin(d));
        double d3 = (double)RandomUtils.nextSign() * this._radius * Math.cos(d);
        this._electronLine.setLine(-d2, -d3, d2, d3);
        assert (this._electronLine.getX1() < this._electronLine.getX2());
        this._electronDirectionPositive = RandomUtils.nextBoolean();
        this.setElectronOffset(0.0, 0.0);
    }

    private double getElectronAmplitude() {
        return (double)this._numberOfPhotonsAbsorbed / 1.0;
    }

    private int getElectronDirectionSign() {
        return this._electronDirectionPositive ? 1 : -1;
    }

    private void changeElectronDirection() {
        this._electronDirectionPositive = !this._electronDirectionPositive;
    }

    private int getNumberOfElectronOscillations() {
        return this._numberOfZeroCrossings % 2;
    }

    private boolean signIsDifferent(double d, double d2) {
        return d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0;
    }

    private boolean canAbsorb(Photon photon) {
        return !photon.isEmitted() && this._numberOfPhotonsAbsorbed != 1 && (this._numberOfPhotonsAbsorbed != 0 || !this._electronIsMoving);
    }

    private boolean absorbPhoton(Photon photon) {
        Point2D point2D;
        boolean bl = false;
        if (this.canAbsorb(photon) && PlumPuddingModel.pointsCollide(this._electronPosition, point2D = photon.getPositionRef(), COLLISION_CLOSENESS) && this._randomAbsorption.nextDouble() < 0.5) {
            ++this._numberOfPhotonsAbsorbed;
            assert (this._numberOfPhotonsAbsorbed <= 1);
            this.firePhotonAbsorbed(photon);
            bl = true;
        }
        return bl;
    }

    private void emitPhoton() {
        if (this._numberOfPhotonsAbsorbed > 0) {
            --this._numberOfPhotonsAbsorbed;
            Point2D point2D = this._electronPosition;
            double d = RandomUtils.nextAngle();
            double d2 = 5.0;
            this.firePhotonEmitted(new Photon(150.0, point2D, d, d2, true));
        }
    }

    public void movePhoton(Photon photon, double d) {
        boolean bl = this.absorbPhoton(photon);
        if (!bl) {
            super.movePhoton(photon, d);
        }
    }

    public void moveAlphaParticle(AlphaParticle alphaParticle, double d) {
        if (Math.abs(alphaParticle.getX() - this.getX()) < 10.0) {
            super.moveAlphaParticle(alphaParticle, d);
        } else {
            RutherfordScattering.moveParticle(this, alphaParticle, d);
        }
    }

    public void stepInTime(double d) {
        if (this._numberOfPhotonsAbsorbed > 0) {
            this._electronIsMoving = true;
            double d2 = this.getElectronAmplitude();
            this.moveElectron(d, d2);
            if (this.getNumberOfElectronOscillations() != 0 && this._randomEmission.nextDouble() < 0.1) {
                this.emitPhoton();
                if (this._numberOfPhotonsAbsorbed == 0) {
                    this._previousAmplitude = d2;
                }
            }
        } else if (this._electronIsMoving && this._numberOfPhotonsAbsorbed == 0) {
            int n = this.getNumberOfElectronOscillations();
            this.moveElectron(d, this._previousAmplitude);
            int n2 = this.getNumberOfElectronOscillations();
            if (n != n2) {
                this._electronIsMoving = false;
                this._numberOfZeroCrossings = 0;
                this._previousAmplitude = 0.0;
                this.updateElectronLine();
                this.setElectronOffset(0.0, 0.0);
            }
        }
    }

    private void moveElectron(double d, double d2) {
        assert (this._electronLine.getX1() < this._electronLine.getX2());
        assert (Math.abs(this._electronLine.getX1()) == Math.abs(this._electronLine.getX2()));
        assert (Math.abs(this._electronLine.getY1()) == Math.abs(this._electronLine.getY2()));
        double d3 = this._electronOffset.getX();
        double d4 = this._electronOffset.getY();
        double d5 = d * (d2 * (2.0 * this._radius) / 30.0);
        double d6 = Math.abs(this._electronLine.getX1()) * (d5 / this._radius);
        double d7 = Math.abs(this._electronLine.getY1()) * (d5 / this._radius);
        double d8 = this.getElectronDirectionSign();
        d6 *= d8;
        d7 *= d8;
        if (this._electronLine.getY1() > this._electronLine.getY2()) {
            d7 *= -1.0;
        }
        double d9 = this._electronOffset.getX() + d6;
        double d10 = this._electronOffset.getY() + d7;
        if (Math.abs(d9) > Math.abs(this._electronLine.getX1()) || Math.abs(d10) > Math.abs(this._electronLine.getY1())) {
            if (this._electronDirectionPositive) {
                d9 = this._electronLine.getX2();
                d10 = this._electronLine.getY2();
            } else {
                d9 = this._electronLine.getX1();
                d10 = this._electronLine.getY1();
            }
            this.changeElectronDirection();
        }
        if (d9 == 0.0 && d10 == 0.0 || this.signIsDifferent(d9, d3) || this.signIsDifferent(d10, d4)) {
            ++this._numberOfZeroCrossings;
        }
        this.setElectronOffset(d9, d10);
    }
}

