/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.hydrogenatom.model.MovingObject;
import edu.colorado.phet.hydrogenatom.util.DebugUtils;
import java.awt.geom.Point2D;

public class Photon
extends MovingObject
implements ModelElement {
    private double _wavelength;
    private boolean _emitted;
    private boolean _collided;

    public Photon(double d, Point2D point2D, double d2, double d3) {
        this(d, point2D, d2, d3, false);
    }

    public Photon(double d, Point2D point2D, double d2, double d3, boolean bl) {
        super(point2D, d2, d3);
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid wavelength: " + d);
        }
        this._wavelength = d;
        this._emitted = bl;
        this._collided = false;
    }

    public double getWavelength() {
        return this._wavelength;
    }

    public boolean isEmitted() {
        return this._emitted;
    }

    public void setCollided(boolean bl) {
        this._collided = bl;
    }

    public boolean isCollided() {
        return this._collided;
    }

    public void stepInTime(double d) {
    }

    public String toString() {
        String string = "Photon ";
        string = string + "id=" + this.getId() + " ";
        string = string + "wavelength=" + DebugUtils.format(this._wavelength) + " ";
        string = string + "position=" + DebugUtils.format(this.getPositionRef()) + " ";
        string = string + "orientation=" + DebugUtils.format(Math.toDegrees(this.getOrientation())) + " ";
        return string;
    }
}

