/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import java.util.ArrayList;

public class Model
extends ClockAdapter {
    private ArrayList<ModelElement> _modelElements;
    private ArrayList<ModelListener> _listeners;

    public Model(IClock iClock) {
        iClock.addClockListener(this);
        this._modelElements = new ArrayList();
        this._listeners = new ArrayList();
    }

    public void clockTicked(ClockEvent clockEvent) {
        double d = clockEvent.getSimulationTimeChange();
        for (ModelElement modelElement : new ArrayList<ModelElement>(this._modelElements)) {
            modelElement.stepInTime(d);
        }
    }

    protected void addModelElement(ModelElement modelElement) {
        this._modelElements.add(modelElement);
        this.fireModelElementAdded(modelElement);
    }

    protected void removeModelElement(ModelElement modelElement) {
        this._modelElements.remove(modelElement);
        this.fireModelElementRemoved(modelElement);
    }

    public void addModelListener(ModelListener modelListener) {
        this._listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this._listeners.remove(modelListener);
    }

    private void fireModelElementAdded(ModelElement modelElement) {
        for (ModelListener modelListener : new ArrayList<ModelListener>(this._listeners)) {
            modelListener.modelElementAdded(modelElement);
        }
    }

    private void fireModelElementRemoved(ModelElement modelElement) {
        for (ModelListener modelListener : new ArrayList<ModelListener>(this._listeners)) {
            modelListener.modelElementRemoved(modelElement);
        }
    }

    public static interface ModelListener {
        public void modelElementAdded(ModelElement var1);

        public void modelElementRemoved(ModelElement var1);
    }
}

