/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.hacks;

import edu.colorado.phet.common.piccolophet.nodes.WavelengthControl;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GunWavelengthControl
extends WavelengthControl {
    public static int KNOB_HILITE_THRESHOLD = 3;
    private static final Stroke KNOB_NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke KNOB_HILITE_STROKE = new BasicStroke(2.0f);
    private static final Color KNOB_NORMAL_COLOR = Color.BLACK;
    private static final Color KNOB_HILITE_COLOR = Color.WHITE;
    private static final Stroke TRANSITION_MARKS_STROKE = new BasicStroke(1.0f);
    private static final Color TRANSITION_MARKS_COLOR = Color.BLACK;
    private static final Color ALTERNATE_CURSOR_COLOR = Color.WHITE;
    private double[] _transitionWavelengths;
    private double _bestMatch;
    private boolean _dragging;
    private boolean _hiliteTransitionWavelengths;
    private PNode _transitionMarksNode;
    private boolean _transitionMarksVisible;

    public GunWavelengthControl(double d, double d2, Color color, Color color2, Color color3, Color color4) {
        super(300, 25, d, d2, color, color2, color3, color4);
        this.setCursorColor(ALTERNATE_CURSOR_COLOR);
        this.addKnobListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                GunWavelengthControl.this.startDragging();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                GunWavelengthControl.this.stopDragging();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (GunWavelengthControl.this._hiliteTransitionWavelengths) {
                    GunWavelengthControl.this.updateKnob();
                }
            }
        });
        this._transitionWavelengths = null;
        this._hiliteTransitionWavelengths = false;
        this._bestMatch = -1.0;
        this._dragging = false;
        this._transitionMarksVisible = false;
        this.updateKnob();
    }

    public void setTransitionWavelengths(double[] dArray) {
        this._transitionWavelengths = dArray;
        this.updateKnob();
        this.updateTransitionMarks();
    }

    public void setKnobHilitingEnabled(boolean bl) {
        this._hiliteTransitionWavelengths = bl;
        this.updateKnob();
    }

    public void setTransitionMarksVisible(boolean bl) {
        this._transitionMarksVisible = bl;
        if (this._transitionMarksNode != null) {
            this._transitionMarksNode.setVisible(bl);
        }
    }

    private void startDragging() {
        this._dragging = true;
    }

    private void stopDragging() {
        this._dragging = false;
        if (this._bestMatch != -1.0) {
            this.setWavelength(this._bestMatch);
        }
    }

    private boolean isClose(double d, double d2) {
        double d3 = d2 - (double)KNOB_HILITE_THRESHOLD;
        double d4 = d2 + (double)KNOB_HILITE_THRESHOLD;
        return d >= d3 && d <= d4;
    }

    private void updateKnob() {
        double d = this.getWavelength();
        this._bestMatch = -1.0;
        double d2 = 0.0;
        double d3 = 1.0E9;
        if (this._transitionWavelengths != null && this._transitionWavelengths.length != 0) {
            for (int i = 0; i < this._transitionWavelengths.length; ++i) {
                if (!this.isClose(d, this._transitionWavelengths[i]) || !((d2 = Math.abs(this._transitionWavelengths[i] - d)) < d3)) continue;
                d3 = d2;
                this._bestMatch = this._transitionWavelengths[i];
            }
        }
        if (this._bestMatch == -1.0) {
            this.setKnobStroke(KNOB_NORMAL_STROKE);
            this.setKnobStrokeColor(KNOB_NORMAL_COLOR);
        } else {
            this.setKnobStroke(KNOB_HILITE_STROKE);
            this.setKnobStrokeColor(KNOB_HILITE_COLOR);
        }
    }

    private void updateTransitionMarks() {
        PNode pNode = this.getTrackBorder();
        if (this._transitionMarksNode != null) {
            pNode.removeChild(this._transitionMarksNode);
            this._transitionMarksNode = null;
        }
        if (this._transitionWavelengths != null) {
            double d = pNode.getFullBounds().getWidth();
            double d2 = pNode.getFullBounds().getHeight();
            double d3 = this.getMinWavelength();
            double d4 = this.getMaxWavelength();
            double d5 = this.getTrackFullBounds().getWidth();
            double d6 = d - d5;
            this._transitionMarksNode = new PComposite();
            this._transitionMarksNode.setVisible(this._transitionMarksVisible);
            pNode.addChild(this._transitionMarksNode);
            for (int i = 0; i < this._transitionWavelengths.length; ++i) {
                double d7 = this._transitionWavelengths[i];
                double d8 = d5 * (d7 - d3) / (d4 - d3) + d6 / 2.0;
                PPath pPath = new PPath(new Line2D.Double(d8, 0.0, d8, d2));
                pPath.setStroke(TRANSITION_MARKS_STROKE);
                pPath.setStrokePaint(TRANSITION_MARKS_COLOR);
                this._transitionMarksNode.addChild(pPath);
            }
        }
    }
}

