/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.energydiagrams;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.hydrogenatom.energydiagrams.AbstractEnergyDiagram;
import edu.colorado.phet.hydrogenatom.model.SolarSystemModel;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class SolarSystemEnergyDiagram
extends AbstractEnergyDiagram
implements Observer {
    private SolarSystemModel _atom;

    public SolarSystemEnergyDiagram(IClock iClock) {
        super(0);
    }

    public void setAtom(SolarSystemModel solarSystemModel) {
        if (this._atom != null) {
            this._atom.deleteObserver(this);
            this._atom = null;
        }
        ElectronNode electronNode = this.getElectronNode();
        electronNode.setVisible(solarSystemModel != null);
        if (solarSystemModel != null) {
            this._atom = solarSystemModel;
            this._atom.addObserver(this);
            this.updateElectronPosition();
        }
    }

    public void clearAtom() {
        this.setAtom(null);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._atom) {
            if (object == "electronOffset") {
                this.updateElectronPosition();
            } else if (object == "atomDestroyed") {
                this.clearAtom();
            }
        }
    }

    private void updateElectronPosition() {
        double d;
        ElectronNode electronNode = this.getElectronNode();
        PBounds pBounds = electronNode.getFullBounds();
        Rectangle2D rectangle2D = this.getDrawingArea();
        double d2 = rectangle2D.getX() + pBounds.getWidth() / 2.0 + 15.0;
        double d3 = Double.MAX_VALUE;
        double d4 = this._atom.getElectronDistanceFromCenter();
        if (d4 > 0.0 && (d = -1.0 / (d4 * d4)) >= -0.029220542041054863) {
            double d5 = rectangle2D.getHeight() - 40.0;
            double d6 = d5 * d / -0.029220542041054863;
            d3 = rectangle2D.getY() + 40.0 + d6;
        }
        electronNode.setOffset(d2, d3);
    }
}

