/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.energydiagrams;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.hydrogenatom.energydiagrams.AbstractEnergyDiagram;
import edu.colorado.phet.hydrogenatom.energydiagrams.EnergySquiggle;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.view.particle.ElectronNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;

public class BohrEnergyDiagram
extends AbstractEnergyDiagram
implements Observer {
    private IClock _clock;
    private ClockListener _clockListener;
    private BohrModel _atom;
    private int _nPrevious;
    private EnergySquiggle _squiggle;
    private double _squiggleLifetime;

    public BohrEnergyDiagram(IClock iClock) {
        super(BohrModel.getNumberOfStates());
        assert (BohrModel.getGroundState() == 1);
        assert (BohrModel.getNumberOfStates() == 6);
        for (int i = 1; i <= BohrModel.getNumberOfStates(); ++i) {
            PNode pNode = BohrEnergyDiagram.createStateNode(i);
            double d = this.getXOffset(i);
            double d2 = this.getYOffset(i);
            pNode.setOffset(d, d2);
            this.getStateLayer().addChild(pNode);
        }
        this._clockListener = new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                BohrEnergyDiagram.this.checkSquiggleLifetime(clockEvent.getWallTimeChange());
            }
        };
        this._clock = iClock;
        this._clock.addClockListener(this._clockListener);
    }

    public void setAtom(BohrModel bohrModel) {
        this.removeSquiggle();
        if (this._atom != null) {
            this._atom.deleteObserver(this);
            this._atom = null;
        }
        ElectronNode electronNode = this.getElectronNode();
        electronNode.setVisible(bohrModel != null);
        if (bohrModel != null) {
            this._atom = bohrModel;
            this._atom.addObserver(this);
            this.updateElectronPosition();
            this._nPrevious = bohrModel.getElectronState();
        }
    }

    public void clearAtom() {
        this.setAtom(null);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof BohrModel && object == "electronState") {
            this.updateElectronPosition();
            this.updateSquiggle();
        }
    }

    private void updateSquiggle() {
        this.removeSquiggle();
        if (!this.isVisible()) {
            return;
        }
        int n = this._atom.getElectronState();
        if (n != this._nPrevious) {
            double d = 0.0;
            d = n > this._nPrevious ? BohrModel.getWavelengthAbsorbed(this._nPrevious, n) : BohrModel.getWavelengthAbsorbed(n, this._nPrevious);
            double d2 = this.getXOffset(this._nPrevious) + 5.0;
            double d3 = this.getYOffset(this._nPrevious);
            double d4 = this.getXOffset(n) + 5.0;
            double d5 = this.getYOffset(n);
            this._squiggle = new EnergySquiggle(d2, d3, d4, d5, d);
            this.getSquiggleLayer().addChild(this._squiggle);
            this._nPrevious = n;
        }
    }

    private void removeSquiggle() {
        if (this._squiggle != null) {
            this.getSquiggleLayer().removeChild(this._squiggle);
            this._squiggleLifetime = 0.0;
            this._squiggle = null;
        }
    }

    private void checkSquiggleLifetime(double d) {
        if (this._squiggle != null) {
            this._squiggleLifetime += d;
            if (this._squiggleLifetime > SQUIGGLE_LIFETIME) {
                this.removeSquiggle();
            }
        }
    }

    private void updateElectronPosition() {
        ElectronNode electronNode = this.getElectronNode();
        int n = this._atom.getElectronState();
        double d = this.getXOffset(n) + 5.0;
        double d2 = this.getYOffset(n) - electronNode.getFullBounds().getHeight() / 2.0;
        electronNode.setOffset(d, d2);
    }

    private double getXOffset(int n) {
        return this.getDrawingArea().getX() + 20.0;
    }

    private double getYOffset(int n) {
        double d = this.getEnergy(1);
        double d2 = this.getEnergy(BohrModel.getNumberOfStates());
        double d3 = d2 - d;
        Rectangle2D rectangle2D = this.getDrawingArea();
        double d4 = rectangle2D.getHeight() - 40.0;
        double d5 = rectangle2D.getY() + 20.0 + d4 * (d2 - this.getEnergy(n)) / d3;
        return d5;
    }

    private static PNode createStateNode(int n) {
        PNode pNode = BohrEnergyDiagram.createStateLineNode();
        PNode pNode2 = BohrEnergyDiagram.createStateLabelNode(n);
        PComposite pComposite = new PComposite();
        pComposite.addChild(pNode);
        pComposite.addChild(pNode2);
        pNode.setOffset(0.0, 0.0);
        double d = pNode.getWidth() + 10.0;
        double d2 = -(pNode.getHeight() / 2.0 + pNode2.getHeight() / 2.0);
        if (n == 6) {
            pNode2.setOffset(d, d2 - 3.5);
        } else {
            pNode2.setOffset(d, d2);
        }
        return pComposite;
    }
}

